/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cdms.ds.sforce.soql.cursors.rest;

import com.cognos.cdms.ds.sforce.request.DateUtility;
import com.cognos.cdms.ds.sforce.request.session.SForceAPIException;
import com.cognos.cdms.ds.sforce.soql.cursors.ISForceColumnValue;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class SForceRESTColumnValue
implements ISForceColumnValue {
    private Object ele;

    public SForceRESTColumnValue(Object ele) {
        this.ele = ele;
    }

    @Override
    public Object getValue(Class cls) throws SForceAPIException {
        DateFormat formatter = null;
        Calendar cal = null;
        if (cls.getName().equals(Calendar.class.getName())) {
            if (this.ele == null) {
                return cls.cast(this.ele);
            }
            String valueString = (String)this.ele;
            valueString = valueString.replace("T", " ");
            formatter = DateUtility.dateTimeFormatter;
            if (cal == null) {
                cal = Calendar.getInstance(TimeZone.getDefault());
            }
            try {
                Date date = formatter.parse(valueString);
                cal.setTime(date);
                return cal;
            }
            catch (ParseException e) {
                throw new SForceAPIException(e);
            }
        }
        if (cls.getName().equals(BigDecimal.class.getName())) {
            if (this.ele == null) {
                return cls.cast(this.ele);
            }
            if (this.ele instanceof Double) {
                return new BigDecimal((Double)this.ele);
            }
            if (this.ele instanceof Integer) {
                return new BigDecimal((Integer)this.ele);
            }
            if (this.ele instanceof Long) {
                return new BigDecimal((Long)this.ele);
            }
            if (this.ele instanceof String) {
                return new BigDecimal((String)this.ele);
            }
            return cls.cast(this.ele);
        }
        if (cls.getName().equals(Date.class.getName())) {
            if (this.ele == null) {
                return cls.cast(this.ele);
            }
            formatter = this.ele.toString().length() > 10 ? DateUtility.dateTimeFormatter : DateUtility.dateFormatter;
            try {
                return formatter.parse((String)this.ele);
            }
            catch (ParseException e) {
                throw new SForceAPIException(e);
            }
        }
        return cls.cast(this.ele);
    }

    @Override
    public Object getValue() {
        return this.ele;
    }
}

