/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.tm1;

import com.ibm.cognos.tm1.ErrorCode;
import com.ibm.cognos.tm1.LogCallbackDelegate;
import com.ibm.cognos.tm1.Peer;
import com.ibm.cognos.tm1.SSLConfig;
import com.ibm.cognos.tm1.SecurityMode;
import com.ibm.cognos.tm1.Server;
import com.ibm.cognos.tm1.ServerConfiguration;
import com.ibm.cognos.tm1.TM1Exception;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Locale;

public class API
extends Peer {
    private static boolean s_bLibraryInitialized = false;
    private static String s_strLibraryLocation;
    private int m_nVersion;
    private boolean m_bUnicode;
    private long m_nLoggerDelegatePointer;

    protected static native Object internalInitialize(String var0);

    public static API initialize() throws TM1Exception {
        return (API)API.initializeAPI(null, 90000000, null);
    }

    public static API initialize(String string) throws TM1Exception {
        return (API)API.initializeAPI(string, 90000000, null);
    }

    public static API initialize(int n) throws TM1Exception {
        return (API)API.initializeAPI(null, n, null);
    }

    public static API initialize(String string, int n, String string2) throws TM1Exception {
        return (API)API.initializeAPI(string, n, string2);
    }

    public static API initialize(String string, int n) throws TM1Exception {
        return (API)API.initializeAPI(string, n, null);
    }

    public static API initializeInProcess(String string, String string2) throws TM1Exception {
        String string3;
        String string4 = string3 = string2 == null ? "" : string2;
        if (string3.length() > 0) {
            string3 = string3 + " ";
        }
        string3 = string3 + "-ip";
        return (API)API.initializeAPI(string, 0, string3);
    }

    public static API initializeInProcess(String string) throws TM1Exception {
        String string2 = "-ip";
        return (API)API.initializeAPI(string, 0, string2);
    }

    public static Server initializeInServer(String string, String string2) throws TM1Exception {
        String string3;
        String string4 = string3 = string2 == null ? "" : string2;
        if (string3.length() > 0) {
            string3 = string3 + " ";
        }
        string3 = string3 + "-i$";
        return (Server)API.initializeAPI(string, 0, string3);
    }

    public static Server initializeInServer(String string) throws TM1Exception {
        String string2 = "-i$";
        return (Server)API.initializeAPI(string, 0, string2);
    }

    public static Server initializeInServer() throws TM1Exception {
        return API.initializeInServer(null);
    }

    private static synchronized Object initializeAPI(String string, int n, String string2) throws TM1Exception {
        String string3;
        if (!s_bLibraryInitialized) {
            String string4;
            String string5;
            boolean bl = System.getProperty("os.name").startsWith("Windows");
            String string6 = "ngtm1api.jar";
            String string7 = "%JAR%" + File.separator;
            String string8 = bl ? "NGTM1JNI.dll" : "libngtm1jni.so";
            String string9 = bl ? "NGTM1API.dll" : "libngtm1api.so";
            String string10 = null;
            String string11 = null;
            File file = null;
            File file2 = null;
            String string12 = null;
            try {
                string5 = URLDecoder.decode(API.class.getProtectionDomain().getCodeSource().getLocation().toString(), Charset.defaultCharset().name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string5 = API.class.getProtectionDomain().getCodeSource().getLocation().toString();
            }
            if (!string5.startsWith("file:") || !string5.endsWith(string6)) {
                throw new TM1Exception("TM1 Java API Initialization failed. URI for the JAR " + string5 + " could not be determined.", ErrorCode.JavaAPIInitializationFailed);
            }
            String string13 = bl ? string5.substring(6, string5.length() - string6.length()) : string5.substring(5, string5.length() - string6.length());
            if (bl) {
                string10 = System.getProperty("os.arch").compareToIgnoreCase("amd64") == 0 || System.getProperty("os.arch").compareToIgnoreCase("x86_64") == 0 || System.getProperty("os.arch").compareToIgnoreCase("emt64T") == 0 ? "x64" + File.separator : "x86" + File.separator;
            }
            if (string != null && string.length() > 0) {
                string11 = string.startsWith(string7) ? string13 + string.substring(string7.length()) : string;
                if (!string.endsWith(File.separator)) {
                    string11 = string11 + File.separator;
                }
                if (!(file = new File(string4 = string11 + string8)).exists()) {
                    file = null;
                    if (bl && !(file = new File(string4 = (string11 = string11 + string10) + string8)).exists()) {
                        file = null;
                    }
                }
            }
            if (file == null && !(file = new File(string4 = (string11 = string13) + string8)).exists()) {
                file = null;
                if (bl && !(file = new File(string4 = (string11 = string11 + string10) + string8)).exists()) {
                    file = null;
                }
            }
            if (file == null) {
                throw new TM1Exception("TM1 Java API Initialization failed. Additional Information: The Library ('" + string8 + "') could not be found.", ErrorCode.JavaAPIInitializationFailed);
            }
            string12 = string11 + File.separator + string9;
            file2 = new File(string12);
            if (file2.exists()) {
                try {
                    System.load(file2.getPath());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            System.load(file.getPath());
            System.runFinalizersOnExit((boolean)true);
            s_strLibraryLocation = string11;
            s_bLibraryInitialized = true;
        }
        String string14 = string3 = string2 == null ? "" : string2;
        if (n != 0) {
            if (string3.length() > 0) {
                string3 = string3 + " ";
            }
            string3 = string3 + "-v ";
            string3 = string3 + Integer.toString(n);
        }
        if (s_strLibraryLocation != null && s_strLibraryLocation.length() > 0) {
            if (string3.length() > 0) {
                string3 = string3 + " ";
            }
            string3 = string3 + "-ll \"";
            string3 = string3 + s_strLibraryLocation;
            string3 = string3 + "\"";
        }
        return API.internalInitialize(string3);
    }

    protected API(long l, int n, boolean bl) {
        super(l);
        this.m_nVersion = n;
        this.m_bUnicode = bl;
    }

    public int getVersion() {
        return this.m_nVersion;
    }

    public boolean isUnicode() {
        return this.m_bUnicode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            this.disposeInternal();
        }
        catch (TM1Exception tM1Exception) {
        }
        finally {
            super.dispose();
        }
    }

    public LogCallbackDelegate initializeLoggers() throws TM1Exception {
        return this.initializeLoggers("");
    }

    public LogCallbackDelegate initializeLoggers(String string) throws TM1Exception {
        if (!s_bLibraryInitialized) {
            throw new TM1Exception("TM1 Java API Not Initialization", ErrorCode.APINotFound);
        }
        return this.internalInitializeLoggers(string);
    }

    public native SecurityMode getServerSecurityMode(String var1, String var2) throws TM1Exception;

    public native ServerConfiguration getServerConfiguration(String var1, String var2) throws TM1Exception;

    public native Server logon(String var1, String var2, String var3, String var4) throws TM1Exception;

    public native Server logon(String var1, String var2, String var3, String var4, Locale var5) throws TM1Exception;

    public native Server logon(String var1, String var2, String var3, String var4, Locale var5, String var6) throws TM1Exception;

    public native Server logonWIA(String var1, String var2) throws TM1Exception;

    public native Server logonWIA(String var1, String var2, Locale var3) throws TM1Exception;

    public native Server logonWIA(String var1, String var2, Locale var3, String var4) throws TM1Exception;

    public native Server logonCAM(String var1, String var2, String var3, String var4) throws TM1Exception;

    public native Server logonCAM(String var1, String var2, String var3, String var4, Locale var5) throws TM1Exception;

    public native Server logonCAM(String var1, String var2, String var3, String var4, Locale var5, String var6) throws TM1Exception;

    public native Server logonCAMNamespace(String var1, String var2, String var3, String var4, String var5) throws TM1Exception;

    public native Server logonCAMNamespace(String var1, String var2, String var3, String var4, String var5, Locale var6) throws TM1Exception;

    public native Server logonCAMNamespace(String var1, String var2, String var3, String var4, String var5, Locale var6, String var7) throws TM1Exception;

    public native Server connectToLimitedDistributedServer(String var1, String var2) throws TM1Exception;

    public native Server connectAsTOPUser(String var1, String var2) throws TM1Exception;

    public native String[] listServerNames(String var1) throws TM1Exception;

    public native SSLConfig getSSLConfig(String var1) throws TM1Exception;

    public native void setSSLConfig(String var1, SSLConfig var2) throws TM1Exception;

    private native LogCallbackDelegate internalInitializeLoggers(String var1) throws TM1Exception;

    private native void disposeInternal() throws TM1Exception;
}

