/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.converters;

import com.ibm.bi.org.apache.hadoop.io.ConfigFactory;
import com.ibm.bi.platform.datasetutils.converters.ConverterOptions;
import com.ibm.bi.platform.datasetutils.converters.DecimalPolicy;
import com.ibm.bi.platform.datasetutils.converters.GenericConverter;
import com.ibm.bi.platform.datasetutils.metadata.Column;
import com.ibm.bi.platform.datasetutils.metadata.ColumnMetadata;
import com.ibm.bi.platform.datasetutils.metadata.types.DecimalType;
import com.ibm.bi.platform.datasetutils.metadata.types.EIntrinsicType;
import com.ibm.bi.platform.datasetutils.metadata.types.Type;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetReadHelper;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetReaderBuilder;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetWriterFactory;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.datasetutils.utils.ArrayRecord;
import com.ibm.bi.platform.datasetutils.utils.DecimalUtils;
import com.ibm.bi.platform.datasetutils.utils.MetadataUtils;
import com.ibm.bi.platform.datasetutils.utils.ReadableRecord;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.BitSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.parquet.hadoop.ParquetReader;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.Path;

public class ParquetConverter
extends GenericConverter {
    private static final Pattern STRING_PATTERN = Pattern.compile("\\s++$");
    private static Configuration conf = new Configuration();
    private ParquetReader<ReadableRecord> pqReader;
    private BitSet trimmableStringColumns = new BitSet();

    public ParquetConverter(String absOutPath) {
        super(absOutPath, new ConverterOptions());
    }

    public ParquetConverter(String absOutPath, ConverterOptions convOpts) {
        super(absOutPath, convOpts);
    }

    public void initialize(String inPath, Map<String, Object> configOptions) throws IOException {
        if (this.converterState != GenericConverter.State.INIT) {
            throw new IllegalStateException("This converter has already been initialized.");
        }
        if (ConfigFactory.initFactory((ConfigFactory)new ConfigFactory(){

            public boolean isEncryptionEnabled() {
                return false;
            }
        })) {
            LOGGER.info("ConfigFactory was not initialized. Encryption is disabled.");
        } else if (ConfigFactory.getConfiguration().isEncryptionEnabled()) {
            LOGGER.info("Encryption behavior (ON) propagated from already initialized ConfigFactory.");
        } else {
            LOGGER.info("Encryption behavior (OFF) propagated from already initialized ConfigFactory.");
        }
        DatasetParquetReadHelper pqReaderHelper = new DatasetParquetReadHelper();
        pqReaderHelper.readFooter(new Path(inPath), conf);
        for (int i = 0; i < pqReaderHelper.getRecordSchema().getNumOfColumns(); ++i) {
            ColumnMetadata currentColumn = pqReaderHelper.getRecordSchema().getColumnMetadata(i);
            Type columnType = currentColumn.getType();
            if (this.converterOpts.shouldRemoveTrailingSpaces() && EIntrinsicType.STRING == columnType.getIntrinsicType()) {
                this.trimmableStringColumns.set(i);
                this.rowSchema.appendColumn(currentColumn);
                continue;
            }
            if (EIntrinsicType.DECIMAL == columnType.getIntrinsicType()) {
                DecimalType originalType = (DecimalType)columnType;
                DecimalType adjustedType = MetadataUtils.adjustDecimalType(currentColumn.getName(), originalType, this.converterOpts);
                if (!adjustedType.equals(originalType)) {
                    this.fieldIdToOriginalDecimalType.put(i, originalType);
                    this.rowSchema.appendColumn(new Column(currentColumn.getName(), currentColumn.isNullable(), adjustedType));
                    continue;
                }
                this.rowSchema.appendColumn(currentColumn);
                continue;
            }
            this.rowSchema.appendColumn(currentColumn);
        }
        this.pqReader = new DatasetParquetReaderBuilder(new Path(inPath)).withParquetVersion(ParquetVersionEnum.LEGACY).withConf(conf).build();
        this.pqWriter = DatasetParquetWriterFactory.create(new Path(this.absoluteOutPath), this.rowSchema, ParquetVersionEnum.VERSION_1, configOptions);
        LOGGER.info("Converting Parquet from ({}, {}) to ({}, {}).", new Object[]{inPath, ParquetVersionEnum.LEGACY.getValue(), this.absoluteOutPath, ParquetVersionEnum.VERSION_1.getValue()});
        this.converterState = GenericConverter.State.READY;
    }

    public void convert() throws IOException {
        if (GenericConverter.State.INIT == this.converterState) {
            throw new IllegalStateException("The converter has not been initialized properly.");
        }
        if (GenericConverter.State.CLOSED == this.converterState) {
            throw new IllegalStateException("The converter has already been closed.");
        }
        if (GenericConverter.State.UNUSUABLE == this.converterState) {
            throw new IllegalStateException("Converter's state is set to UNUSUABLE because a previous conversion operation failed. Use a new converter instead.");
        }
        long recordCount = 0L;
        long convertStartTime = System.currentTimeMillis();
        try {
            ArrayRecord record = (ArrayRecord)this.pqReader.read();
            while (null != record) {
                ++recordCount;
                int id = this.trimmableStringColumns.nextSetBit(0);
                while (id >= 0) {
                    if (!record.isNull(id)) {
                        record.setString(id, STRING_PATTERN.matcher(record.getString(id)).replaceFirst(""));
                    }
                    id = this.trimmableStringColumns.nextSetBit(id + 1);
                }
                for (Map.Entry entry : this.fieldIdToOriginalDecimalType.entrySet()) {
                    if (record.isNull((Integer)entry.getKey())) continue;
                    BigDecimal legacyDecimalValue = record.getDecimal((Integer)entry.getKey());
                    DecimalType originalDecimalType = (DecimalType)entry.getValue();
                    if (DecimalPolicy.LEAST_SIGNIFICANT_DIGITS_REMOVAL == this.converterOpts.getDecimalPolicy()) {
                        record.setDecimal((Integer)entry.getKey(), DecimalUtils.truncateDecimalValue(legacyDecimalValue, originalDecimalType.getPrecision(), ((DecimalType)this.rowSchema.getColumnMetadata((Integer)entry.getKey()).getType()).getScale()));
                        continue;
                    }
                    record.setDecimal((Integer)entry.getKey(), DecimalUtils.fitDecimalValue(this.rowSchema.getColumnMetadata((Integer)entry.getKey()).getName(), recordCount, legacyDecimalValue));
                }
                this.pqWriter.write((Object)record);
                record = (ArrayRecord)this.pqReader.read();
            }
        }
        catch (IOException ioe) {
            try {
                this.converterState = GenericConverter.State.UNUSUABLE;
                throw ioe;
            }
            catch (Throwable throwable) {
                long convertDuration = System.currentTimeMillis() - convertStartTime;
                LOGGER.info("Time in Parquet conversion of {} records, {} columns: {} ms.", new Object[]{recordCount, this.rowSchema.getNumOfColumns(), convertDuration});
                throw throwable;
            }
        }
        long convertDuration = System.currentTimeMillis() - convertStartTime;
        LOGGER.info("Time in Parquet conversion of {} records, {} columns: {} ms.", new Object[]{recordCount, this.rowSchema.getNumOfColumns(), convertDuration});
    }

    @Override
    public void release() {
        long releaseStartTime = System.currentTimeMillis();
        super.release();
        IOUtils.closeQuietly(this.pqReader);
        this.pqReader = null;
        this.converterState = GenericConverter.State.CLOSED;
        LOGGER.info("Time in Parquet close and release: {} ms.", (Object)(System.currentTimeMillis() - releaseStartTime));
    }

    static {
        conf.set("fs.file.impl", "shaded.org.apache.hadoop.fs.RawLocalFileSystem");
    }
}

