/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.converters;

import com.ibm.bi.org.apache.hadoop.io.ConfigFactory;
import com.ibm.bi.platform.datasetutils.converters.CSVReadableRecord;
import com.ibm.bi.platform.datasetutils.converters.ConverterOptions;
import com.ibm.bi.platform.datasetutils.converters.DecimalPolicy;
import com.ibm.bi.platform.datasetutils.converters.GenericConverter;
import com.ibm.bi.platform.datasetutils.metadata.Column;
import com.ibm.bi.platform.datasetutils.metadata.ColumnMetadata;
import com.ibm.bi.platform.datasetutils.metadata.types.DecimalType;
import com.ibm.bi.platform.datasetutils.metadata.types.EIntrinsicType;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetWriterFactory;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.datasetutils.utils.MetadataUtils;
import com.ibm.bi.platform.moser.common.utils.IdentifierUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import shaded.org.apache.hadoop.fs.Path;

public final class RSVPCsvToParquetConverter
extends GenericConverter {
    private static final String MASTER_DATASET = "masterDataset";
    private static final String COLUMN_INFO = "//columnInfo";
    private static final String ATT_NAME = "name";
    private static final String ATT_TYPE = "type";
    private static final String ATT_PRECISION = "precision";
    private static final String ATT_SCALE = "scale";
    private static final String ATT_NULLS_OK = "nullsOk";
    private boolean alreadySkippedHeaders = false;
    private final ParquetVersionEnum parquetVersion;
    private Set<Integer> int64AsDecimalFieldIds = new HashSet<Integer>();
    private Set<Integer> unsupportedTypeFieldIds = new HashSet<Integer>();
    private CSVReadableRecord readableRecord;

    RSVPCsvToParquetConverter(String absOutPath, ParquetVersionEnum pqVersion, ConverterOptions convOpts) {
        super(absOutPath, convOpts);
        this.parquetVersion = pqVersion;
    }

    public int initialize(InputStream mds, Map<String, Object> configOptions) throws DocumentException, IOException {
        if (null == mds) {
            throw new IllegalArgumentException("Expected a non-NULL RSVP Master Dataset stream.");
        }
        if (this.converterState != GenericConverter.State.INIT) {
            throw new IllegalStateException("This converter has already been initialized.");
        }
        SAXReader reader = new SAXReader();
        Document document = reader.read(mds);
        if (null != document) {
            Element column;
            Element masterDatasetElement = document.getRootElement();
            if (!MASTER_DATASET.equals(masterDatasetElement.getName())) {
                masterDatasetElement = (Element)masterDatasetElement.selectSingleNode(MASTER_DATASET);
            }
            if (null == masterDatasetElement) {
                throw new DocumentException("Failed to construct a metadata representation from RSVP's Master Dataset.");
            }
            List columns = masterDatasetElement.selectNodes(COLUMN_INFO);
            ArrayList<Element> filteredColumns = new ArrayList<Element>();
            ArrayList<String> originalNames = new ArrayList<String>();
            for (Node current : columns) {
                column = (Element)current;
                if (MetadataUtils.isProperty(column)) continue;
                filteredColumns.add(column);
                originalNames.add(column.attributeValue(ATT_NAME));
            }
            String[] identifiers = IdentifierUtil.convertToValidUniqueIdentifiers((String[])originalNames.toArray(new String[originalNames.size()]));
            for (int i = 0; i < filteredColumns.size(); ++i) {
                column = (Element)filteredColumns.get(i);
                byte type = Byte.parseByte(column.attributeValue(ATT_TYPE));
                int precision = Integer.parseInt(column.attributeValue(ATT_PRECISION));
                int scale = Integer.parseInt(column.attributeValue(ATT_SCALE));
                int nullsOk = Integer.parseInt(column.attributeValue(ATT_NULLS_OK));
                ColumnMetadata columnMd = MetadataUtils.generateColumnFromRSVPMasterDataset(identifiers[i], type, precision, scale, nullsOk);
                if (ParquetVersionEnum.LEGACY != this.parquetVersion && EIntrinsicType.DECIMAL == columnMd.getType().getIntrinsicType()) {
                    Column currentColumn = (Column)columnMd;
                    DecimalType originalType = (DecimalType)columnMd.getType();
                    DecimalType adjustedType = MetadataUtils.adjustDecimalType(currentColumn.getName(), originalType, this.converterOpts);
                    if (adjustedType != originalType) {
                        this.fieldIdToOriginalDecimalType.put(i, originalType);
                    }
                    columnMd = new Column(currentColumn.getName(), currentColumn.isNullable(), adjustedType);
                }
                this.rowSchema.appendColumn(columnMd);
                if ((8 == type || 54 == type) && scale != 0) {
                    this.int64AsDecimalFieldIds.add(i);
                    continue;
                }
                if (MetadataUtils.isSupportedType(type)) continue;
                this.unsupportedTypeFieldIds.add(i);
            }
        } else {
            throw new DocumentException("Failed to construct a metadata representation from RSVP's Master Dataset.");
        }
        if (ConfigFactory.initFactory((ConfigFactory)new ConfigFactory(){

            public boolean isEncryptionEnabled() {
                return false;
            }
        })) {
            LOGGER.info("ConfigFactory was not initialized. Encryption is disabled.");
        } else if (ConfigFactory.getConfiguration().isEncryptionEnabled()) {
            LOGGER.info("Encryption behavior (ON) propagated from already initialized ConfigFactory.");
        } else {
            LOGGER.info("Encryption behavior (OFF) propagated from already initialized ConfigFactory.");
        }
        this.pqWriter = DatasetParquetWriterFactory.create(new Path(this.absoluteOutPath), this.rowSchema, this.parquetVersion, configOptions);
        this.readableRecord = new CSVReadableRecord(this.rowSchema, this.int64AsDecimalFieldIds, this.unsupportedTypeFieldIds, this.fieldIdToOriginalDecimalType, this.parquetVersion, this.converterOpts);
        this.converterState = GenericConverter.State.READY;
        return this.rowSchema.getNumOfColumns();
    }

    public int convert(InputStream src, Charset charSet) throws IOException {
        if (null == src) {
            throw new IllegalArgumentException("Expected a non-NULL csv input stream.");
        }
        if (GenericConverter.State.INIT == this.converterState) {
            throw new IllegalStateException("The converter has not been initialized properly.");
        }
        if (GenericConverter.State.CLOSED == this.converterState) {
            throw new IllegalStateException("The converter has already been closed.");
        }
        if (GenericConverter.State.UNUSUABLE == this.converterState) {
            throw new IllegalStateException("Converter's state is set to UNUSUABLE because a previous conversion operation failed. Use a new converter instead.");
        }
        int recordCount = 0;
        long convertStartTime = System.currentTimeMillis();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(src, charSet));){
            if (!this.alreadySkippedHeaders) {
                bufferedReader.readLine();
                this.alreadySkippedHeaders = true;
            }
            CSVParser parser = new CSVParser((Reader)bufferedReader, CSVFormat.EXCEL);
            for (CSVRecord record : parser) {
                if (recordCount == 0 && record.size() != this.rowSchema.getNumOfColumns()) {
                    throw new IOException(String.format("Parsed number of columns (%d) does not match with RSVP Master Dataset's number of columns (%d).", record.size(), this.rowSchema.getNumOfColumns()));
                }
                this.readableRecord.setRecord(record, ++recordCount);
                this.pqWriter.write((Object)this.readableRecord);
            }
        }
        catch (IOException ioe) {
            try {
                this.converterState = GenericConverter.State.UNUSUABLE;
                throw ioe;
            }
            catch (Throwable throwable) {
                long convertDuration = System.currentTimeMillis() - convertStartTime;
                LOGGER.info("Time in Parquet conversion of {} records, {} columns: {} ms.", new Object[]{recordCount, this.rowSchema.getNumOfColumns(), convertDuration});
                throw throwable;
            }
        }
        long convertDuration = System.currentTimeMillis() - convertStartTime;
        LOGGER.info("Time in Parquet conversion of {} records, {} columns: {} ms.", new Object[]{recordCount, this.rowSchema.getNumOfColumns(), convertDuration});
        return recordCount;
    }

    @Override
    public void release() {
        long releaseStartTime = System.currentTimeMillis();
        super.release();
        this.converterState = GenericConverter.State.CLOSED;
        LOGGER.info("Time in Parquet close and release: {} ms.", (Object)(System.currentTimeMillis() - releaseStartTime));
    }

    public static class Builder {
        private String outPath;
        private ParquetVersionEnum thePQVersion = ParquetVersionEnum.VERSION_1;
        private ConverterOptions convOpts = new ConverterOptions();

        public Builder(String path) throws IOException {
            if (null == path) {
                throw new IllegalArgumentException("Expected a non NULL argument as output path.");
            }
            File f = new File(path);
            if (!f.isAbsolute()) {
                throw new IllegalArgumentException("Expected absolute path location.");
            }
            if (f.exists() && !f.delete()) {
                throw new IOException("Existing file in the provided location cannot be deleted.");
            }
            this.outPath = path;
        }

        public Builder setOutputFilePQVersion(ParquetVersionEnum pqVersion) {
            this.thePQVersion = pqVersion;
            return this;
        }

        public Builder setRemoveTrailingSpaces(boolean removeTrailingSpaces) {
            this.convOpts.put("removeTrailingSpaces", removeTrailingSpaces);
            return this;
        }

        public Builder setDecimalPolicy(DecimalPolicy policy) {
            this.convOpts.put("decimalPolicy", policy);
            return this;
        }

        public RSVPCsvToParquetConverter build() {
            GenericConverter.LOGGER.info("Creating a new instance of RSVPCsvToParquetConverter with (absOutPath, parquetVersion): ({}, {}).", (Object)this.outPath, (Object)this.thePQVersion.getValue());
            return new RSVPCsvToParquetConverter(this.outPath, this.thePQVersion, this.convOpts);
        }
    }
}

