/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.metadata.types;

public final class CCLTypeCode {
    public static final byte CCLDTYPEUNKNOWN = 0;
    public static final byte CCLDTYPESTRING = 1;
    public static final byte CCLDTYPEINT8 = 2;
    public static final byte CCLDTYPEUINT8 = 3;
    public static final byte CCLDTYPEINT16 = 4;
    public static final byte CCLDTYPEUINT16 = 5;
    public static final byte CCLDTYPEINT32 = 6;
    public static final byte CCLDTYPEUINT32 = 7;
    public static final byte CCLDTYPEINT64 = 8;
    public static final byte CCLDTYPEUINT64 = 9;
    public static final byte CCLDTYPEFLOAT = 10;
    public static final byte CCLDTYPEDOUBLE = 11;
    public static final byte CCLDTYPEDECIMAL = 12;
    public static final byte CCLDTYPEDATE = 13;
    public static final byte CCLDTYPETIME = 14;
    public static final byte CCLDTYPEDATETIME = 15;
    public static final byte CCLDTYPETIMESTAMP = 15;
    public static final byte CCLDTYPEDTINTERVAL = 16;
    public static final byte CCLDTYPEYMINTERVAL = 17;
    public static final byte CCLDTYPEBLOB = 18;
    public static final byte CCLDTYPEROWITERATOR = 19;
    public static final byte CCLDTYPEDIMITERATOR = 20;
    public static final byte CCLDTYPEMASTERDATASET = 21;
    public static final byte CCLDTYPEVARIANT = 22;
    public static final byte CCLDTYPEBINARY = 23;
    public static final byte CCLDTYPEVARBINARY = 24;
    public static final byte CCLDTYPEMEMBERUNIQUENAME = 25;
    public static final byte CCLDTYPEMEMBERCAPTION = 26;
    public static final byte CCLDTYPEDIMENSIONUNIQUENAME = 27;
    public static final byte CCLDTYPEPARENTUNIQUENAME = 28;
    public static final byte CCLDTYPEDESCRIPTION = 29;
    public static final byte CCLDTYPEHIERARCHYUNIQUENAME = 30;
    public static final byte CCLDTYPEPARENTLEVEL = 31;
    public static final byte CCLDTYPELEVELUNIQUENAME = 32;
    public static final byte CCLDTYPELEVELNUMBER = 33;
    public static final byte CCLDTYPELEVELLABEL = 34;
    public static final byte CCLDTYPEFORMATTEDVALUE = 35;
    public static final byte CCLDTYPEFONT = 36;
    public static final byte CCLDTYPEFORECOLOR = 37;
    public static final byte CCLDTYPEBACKCOLOR = 38;
    public static final byte CCLDTYPEFONTFLAGS = 39;
    public static final byte CCLDTYPEORDINAL = 40;
    public static final byte CCLDTYPENESTEDDIM = 41;
    public static final byte CCLDTYPENUMBEROFPARENTS = 42;
    public static final byte CCLDTYPEMEMBERTYPE = 43;
    public static final byte CCLDTYPEHASCHILDREN = 44;
    public static final byte CCLDTYPEEXTERNALBUFFER = 45;
    public static final byte CCLDTYPETEXTBLOB = 46;
    public static final byte CCLDTYPEMIME = 47;
    public static final byte CCLDTYPEURL = 48;
    public static final byte CCLDTYPECURRENCY = 49;
    public static final byte CCLDTYPEMEASUREITEM = 50;
    public static final byte CCLDTYPEBOOLEAN = 51;
    public static final byte CCLDTYPETIMETZ = 52;
    public static final byte CCLDTYPETIMESTAMPTZ = 53;
    public static final byte CCLDTYPENUMERIC = 54;
    public static final byte CCLDTYPENCHAR = 55;
    public static final byte CCLDTYPENVARCHAR = 56;
    public static final byte CCLDTYPEDATE2 = 57;
    public static final byte CCLDTYPETIME2 = 58;
    public static final byte CCLDTYPETIMESTAMP2 = 59;
    public static final byte CCLDTYPEINTERVAL2 = 60;
    public static final byte CCLDTYPEXML = 100;
    public static final byte CCLDTYPEROW = 101;
    public static final byte CCLDTYPEARRAY = 102;
    public static final byte CCLDTYPEMULTISET = 103;
    public static final byte CCLDTYPESTRUCT = 104;
    public static final byte CCLDTYPEJAVAOBJECT = 105;
    public static final byte CCLDTYPEREF = 106;
    public static final byte CCLDTYPENULL = 107;
    public static final byte CCLDTYPEPERIOD_DATE = 108;
    public static final byte CCLDTYPEPERIOD_TIME = 109;
    public static final byte CCLDTYPEPERIOD_TIMETZ = 110;
    public static final byte CCLDTYPEPERIOD_TIMESTAMP = 111;
    public static final byte CCLDTYPEPERIOD_TIMESTAMPTZ = 112;
    public static final byte CCLDTYPEMAP = 113;
    public static final byte CCLDTYPEJSON = 114;

    private CCLTypeCode() {
    }

    public static String getCCLTypeName(int cclType) {
        String name = "cclDTypeUnknown";
        switch (cclType) {
            case 0: {
                break;
            }
            case 1: {
                name = "cclDTypeString";
                break;
            }
            case 2: {
                name = "cclDTypeInt8";
                break;
            }
            case 4: {
                name = "cclDTypeInt16";
                break;
            }
            case 6: {
                name = "cclDTypeInt32";
                break;
            }
            case 3: {
                name = "cclDTypeUInt8";
                break;
            }
            case 5: {
                name = "cclDTypeUInt16";
                break;
            }
            case 7: {
                name = "cclDTypeUInt32";
                break;
            }
            case 8: {
                name = "cclDTypeInt64";
                break;
            }
            case 9: {
                name = "cclDTypeUInt64";
                break;
            }
            case 10: {
                name = "cclDTypeFloat";
                break;
            }
            case 11: {
                name = "cclDTypeDouble";
                break;
            }
            case 12: {
                name = "cclDTypeDecimal";
                break;
            }
            case 13: {
                name = "cclDTypeDate";
                break;
            }
            case 14: {
                name = "cclDTypeTime";
                break;
            }
            case 15: {
                name = "cclDTypeDateTime";
                break;
            }
            case 16: {
                name = "cclDTypeDTInterval";
                break;
            }
            case 17: {
                name = "cclDTypeYMInterval";
                break;
            }
            case 18: {
                name = "cclDTypeBlob";
                break;
            }
            case 19: {
                name = "cclDTypeRowIterator";
                break;
            }
            case 20: {
                name = "cclDTypeDimIterator";
                break;
            }
            case 21: {
                name = "cclDTypeMasterDataset";
                break;
            }
            case 22: {
                name = "cclDTypeVariant";
                break;
            }
            case 23: {
                name = "cclDTypeBinary";
                break;
            }
            case 24: {
                name = "cclDTypeVarBinary";
                break;
            }
            case 25: {
                name = "cclDTypeMemberUniqueName";
                break;
            }
            case 26: {
                name = "cclDTypeMemberCaption";
                break;
            }
            case 27: {
                name = "cclDTypeDimensionUniqueName";
                break;
            }
            case 28: {
                name = "cclDTypeParentUniqueName";
                break;
            }
            case 29: {
                name = "cclDTypeDescription";
                break;
            }
            case 30: {
                name = "cclDTypeHierarchyUniqueName";
                break;
            }
            case 31: {
                name = "cclDTypeParentLevel";
                break;
            }
            case 32: {
                name = "cclDTypeLevelUniqueName";
                break;
            }
            case 33: {
                name = "cclDTypeLevelNumber";
                break;
            }
            case 34: {
                name = "cclDTypeLevelLabel";
                break;
            }
            case 35: {
                name = "cclDTypeFormattedValue";
                break;
            }
            case 36: {
                name = "cclDTypeFont";
                break;
            }
            case 37: {
                name = "cclDTypeForeColor";
                break;
            }
            case 38: {
                name = "cclDTypeBackColor";
                break;
            }
            case 39: {
                name = "cclDTypeFontFlags";
                break;
            }
            case 40: {
                name = "cclDTypeOrdinal";
                break;
            }
            case 41: {
                name = "cclDTypeNestedDim";
                break;
            }
            case 42: {
                name = "cclDTypeNumberOfParents";
                break;
            }
            case 43: {
                name = "cclDTypeMemberType";
                break;
            }
            case 44: {
                name = "cclDTypeHasChildren";
                break;
            }
            case 45: {
                name = "cclDTypeExternalBuffer";
                break;
            }
            case 46: {
                name = "cclDTypeTextBlob";
                break;
            }
            case 47: {
                name = "cclDTypeMIME";
                break;
            }
            case 48: {
                name = "cclDTypeURL";
                break;
            }
            case 49: {
                name = "cclDTypeCurrency";
                break;
            }
            case 50: {
                name = "cclDTypeMeasureItem";
                break;
            }
            case 51: {
                name = "cclDTypeBoolean";
                break;
            }
            case 52: {
                name = "cclDTypeTimeTZ";
                break;
            }
            case 53: {
                name = "cclDTypeTimestampTZ";
                break;
            }
            case 54: {
                name = "cclDTypeNumeric";
                break;
            }
            case 55: {
                name = "cclDTypeNChar";
                break;
            }
            case 56: {
                name = "cclDTypeNVarChar";
                break;
            }
            case 57: {
                name = "cclDTypeDate2";
                break;
            }
            case 58: {
                name = "cclDTypeTime2";
                break;
            }
            case 59: {
                name = "cclDTypeTimestamp2";
                break;
            }
            case 60: {
                name = "cclDTypeInterval2";
                break;
            }
            case 100: {
                name = "cclDTypeXml";
                break;
            }
            case 101: {
                name = "cclDTypeRow";
                break;
            }
            case 102: {
                name = "cclDTypeArray";
                break;
            }
            case 103: {
                name = "cclDTypeMultiset";
                break;
            }
            case 104: {
                name = "cclDTypeStruct";
                break;
            }
            case 105: {
                name = "cclDTypeJavaObject";
                break;
            }
            case 106: {
                name = "cclDTypeRef";
                break;
            }
            case 107: {
                name = "cclDTypeNull";
                break;
            }
            case 108: {
                name = "cclDTypePeriodDate";
                break;
            }
            case 109: {
                name = "cclDTypePeriodTime";
                break;
            }
            case 110: {
                name = "cclDTypePeriodTimeTZ";
                break;
            }
            case 111: {
                name = "cclDTypePeriodTimestamp";
                break;
            }
            case 112: {
                name = "cclDTypePeriodTimestampTZ";
                break;
            }
            case 113: {
                name = "cclDTypeMap";
                break;
            }
            case 114: {
                name = "cclDTypeJson";
                break;
            }
        }
        return name;
    }

    public static boolean isDate(byte type) {
        return type == 57;
    }

    public static boolean isTime(byte type) {
        return type == 58 || type == 52;
    }

    public static boolean isTimestamp(byte type) {
        return type == 59 || type == 53;
    }

    public static boolean isInterval(byte type) {
        return type == 60 || type == 17;
    }

    public static boolean isInteger(byte type) {
        return type == 2 || type == 4 || type == 6 || type == 8;
    }

    public static boolean isBinary(byte type) {
        return type == 23 || type == 24;
    }

    public static boolean isBoolean(byte type) {
        return type == 51;
    }

    public static boolean isBlob(byte type) {
        return type == 18 || type == 46;
    }

    public static boolean isClob(byte type) {
        return type == 46;
    }

    public static boolean isNullType(byte type) {
        return type == 107;
    }

    public static boolean isExactNumeric(byte type) {
        return CCLTypeCode.isInteger(type) || type == 12;
    }

    public static boolean isStruct(byte type) {
        return type == 104;
    }

    public static boolean isXMLType(byte type) {
        return type == 100;
    }

    public static boolean isJSONType(byte type) {
        return type == 114;
    }

    public static boolean isMultisetType(byte type) {
        return type == 103;
    }

    public static boolean isArrayType(byte type) {
        return type == 102;
    }

    public static boolean isVariantType(byte type) {
        return type == 22;
    }

    public static boolean isPeriodType(byte type) {
        return type == 108 || type == 109 || type == 110 || type == 111 || type == 112;
    }

    public static boolean isPromotableTo(byte sourceType, byte targetType) {
        if (sourceType == 107) {
            return true;
        }
        switch (sourceType) {
            case 4: {
                return targetType == 6 || targetType == 8 || targetType == 12 || targetType == 10 || targetType == 11 || targetType == 51;
            }
            case 6: {
                return targetType == 8 || targetType == 12 || targetType == 10 || targetType == 11 || targetType == 51;
            }
            case 8: {
                return targetType == 12 || targetType == 10 || targetType == 11 || targetType == 51;
            }
            case 12: {
                return targetType == 11;
            }
            case 10: 
            case 11: {
                return targetType == 11 || targetType == 51;
            }
            case 45: {
                return targetType == 55 || targetType == 56 || targetType == 1;
            }
            case 57: 
            case 58: {
                return targetType == 59;
            }
            case 16: 
            case 17: 
            case 60: {
                return targetType == 45;
            }
            case 51: {
                return targetType == 45 || targetType == 4 || targetType == 6 || targetType == 8 || targetType == 10 || targetType == 11;
            }
        }
        return false;
    }
}

