/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.metadata.types;

import com.ibm.bi.platform.datasetutils.metadata.types.BaseType;
import com.ibm.bi.platform.datasetutils.metadata.types.CCLTypeCode;
import com.ibm.bi.platform.datasetutils.metadata.types.EIntrinsicType;

public class IntegerType
extends BaseType {
    private final byte cclType;

    protected IntegerType() {
        this.cclType = (byte)6;
    }

    protected IntegerType(byte ccldType) {
        if (2 == ccldType) {
            this.cclType = (byte)2;
        } else if (4 == ccldType) {
            this.cclType = (byte)4;
        } else if (6 == ccldType) {
            this.cclType = (byte)6;
        } else {
            throw new IllegalArgumentException(String.format("The provided CCLDTYPE (%s) cannot be handled by this instance.", CCLTypeCode.getCCLTypeName(ccldType)));
        }
    }

    @Override
    public EIntrinsicType getIntrinsicType() {
        return EIntrinsicType.INT;
    }

    @Override
    public byte getCCLTypeCode() {
        return this.cclType;
    }

    @Override
    public String toXQETypeString() {
        return "INTEGER";
    }
}

