/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.metadata.types;

import com.ibm.bi.platform.datasetutils.metadata.types.BaseType;
import com.ibm.bi.platform.datasetutils.metadata.types.CCLTypeCode;
import com.ibm.bi.platform.datasetutils.metadata.types.EIntrinsicType;
import com.ibm.bi.platform.datasetutils.metadata.types.TemporalType;

public class TimeType
extends BaseType
implements TemporalType {
    private final byte cclType;
    private final String xqeType;

    protected TimeType() {
        this.cclType = (byte)58;
        this.xqeType = "TIME";
    }

    protected TimeType(byte ccldType) {
        if (58 == ccldType) {
            this.cclType = (byte)58;
            this.xqeType = "TIME";
        } else if (52 == ccldType) {
            this.cclType = (byte)52;
            this.xqeType = "TIME WITH TIME ZONE";
        } else {
            throw new IllegalArgumentException(String.format("The provided CCLDTYPE (%s) cannot be handled by this instance.", CCLTypeCode.getCCLTypeName(ccldType)));
        }
    }

    @Override
    public EIntrinsicType getIntrinsicType() {
        return EIntrinsicType.TIME;
    }

    @Override
    public boolean hasDate() {
        return false;
    }

    @Override
    public boolean hasTime() {
        return true;
    }

    @Override
    public boolean hasTimeZone() {
        return 52 == this.cclType;
    }

    @Override
    public byte getCCLTypeCode() {
        return this.cclType;
    }

    @Override
    public String toXQETypeString() {
        return this.xqeType.toUpperCase();
    }
}

