/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.parquet;

import com.ibm.bi.platform.datasetutils.metadata.RowSchema;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetWriterBuilder;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.datasetutils.utils.ReadableRecord;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Map;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.Path;

public abstract class DatasetParquetWriterFactory {
    public static final String BLOCK_SIZE = "block_size";
    public static final String COMPRESSION_CODEC = "compression_codec";

    public static ParquetWriter<ReadableRecord> create(Path outputPath, RowSchema recordSchema, ParquetVersionEnum version, Map<String, Object> configOptions) throws IOException {
        Configuration conf = new Configuration();
        conf.set("fs.file.impl", "shaded.org.apache.hadoop.fs.RawLocalFileSystem");
        DatasetParquetWriterBuilder builder = (DatasetParquetWriterBuilder)new DatasetParquetWriterBuilder(outputPath, recordSchema).withParquetVersion(version).withConf(conf);
        if (ParquetVersionEnum.LEGACY != version) {
            builder.withTimeZoneId(ZoneId.of("UTC"));
        }
        if (configOptions.containsKey(COMPRESSION_CODEC)) {
            builder.withCompressionCodec((CompressionCodecName)configOptions.get(COMPRESSION_CODEC));
        }
        if (configOptions.containsKey(BLOCK_SIZE)) {
            builder.withRowGroupSize((Integer)configOptions.get(BLOCK_SIZE));
        }
        return builder.build();
    }
}

