/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.utils;

import com.ibm.bi.platform.datasetutils.utils.ReadableRecord;
import com.ibm.bi.platform.datasetutils.utils.WritableRecord;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;

public class ArrayRecord
implements ReadableRecord,
WritableRecord {
    private final Object[] array;

    public ArrayRecord(int length) {
        this.array = new Object[length];
    }

    public ArrayRecord(Object[] theArray) {
        this.array = theArray;
    }

    public void clear() {
        Arrays.fill(this.array, null);
    }

    @Override
    public void setNull(int index) {
        this.array[index] = null;
    }

    @Override
    public void setBoolean(int index, boolean value) {
        this.array[index] = value;
    }

    @Override
    public void setBinary(int index, byte[] value) {
        this.array[index] = ByteBuffer.wrap(value);
    }

    @Override
    public void setBinary(int index, ByteBuffer value) {
        this.array[index] = value;
    }

    @Override
    public void setByte(int index, byte value) {
        this.array[index] = value;
    }

    @Override
    public void setDate(int index, LocalDate value) {
        this.array[index] = value;
    }

    @Override
    public void setTime(int index, LocalTime value) {
        this.array[index] = value;
    }

    @Override
    public void setOffsetTime(int index, OffsetTime value) {
        this.array[index] = value;
    }

    @Override
    public void setDateTime(int index, LocalDateTime value) {
        this.array[index] = value;
    }

    @Override
    public void setOffsetDateTime(int index, OffsetDateTime value) {
        this.array[index] = value;
    }

    @Override
    public void setDecimal(int index, BigDecimal value) {
        this.array[index] = value;
    }

    @Override
    public void setDouble(int index, double value) {
        this.array[index] = value;
    }

    @Override
    public void setFloat(int index, float value) {
        this.array[index] = Float.valueOf(value);
    }

    @Override
    public void setInt(int index, int value) {
        this.array[index] = value;
    }

    @Override
    public void setLong(int index, long value) {
        this.array[index] = value;
    }

    @Override
    public void setShort(int index, short value) {
        this.array[index] = value;
    }

    @Override
    public void setString(int index, String value) {
        this.array[index] = value;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isNull(int index) {
        return null == this.array[index];
    }

    @Override
    public boolean getBoolean(int index) {
        return (Boolean)this.array[index];
    }

    @Override
    public ByteBuffer getBinary(int index) {
        return (ByteBuffer)this.array[index];
    }

    @Override
    public byte getByte(int index) {
        return (Byte)this.array[index];
    }

    @Override
    public LocalDate getDate(int index) {
        TemporalAccessor temporal = (TemporalAccessor)this.array[index];
        return LocalDate.from(temporal);
    }

    @Override
    public LocalTime getTime(int index) {
        TemporalAccessor temporal = (TemporalAccessor)this.array[index];
        return LocalTime.from(temporal);
    }

    @Override
    public OffsetTime getOffsetTime(int index) {
        TemporalAccessor temporal = (TemporalAccessor)this.array[index];
        if (temporal.isSupported(ChronoField.OFFSET_SECONDS)) {
            return OffsetTime.from(temporal);
        }
        LocalTime localTime = LocalTime.from(temporal);
        return OffsetTime.of(localTime, ZoneOffset.UTC);
    }

    @Override
    public LocalDateTime getDateTime(int index) {
        TemporalAccessor temporal = (TemporalAccessor)this.array[index];
        return LocalDateTime.from(temporal);
    }

    @Override
    public OffsetDateTime getOffsetDateTime(int index) {
        TemporalAccessor temporal = (TemporalAccessor)this.array[index];
        if (temporal.isSupported(ChronoField.OFFSET_SECONDS)) {
            return OffsetDateTime.from(temporal);
        }
        LocalDateTime localDateTime = LocalDateTime.from(temporal);
        return OffsetDateTime.of(localDateTime, ZoneOffset.UTC);
    }

    @Override
    public BigDecimal getDecimal(int index) {
        return (BigDecimal)this.array[index];
    }

    @Override
    public double getDouble(int index) {
        return (Double)this.array[index];
    }

    @Override
    public float getFloat(int index) {
        return ((Float)this.array[index]).floatValue();
    }

    @Override
    public int getInt(int index) {
        return (Integer)this.array[index];
    }

    @Override
    public long getLong(int index) {
        return (Long)this.array[index];
    }

    @Override
    public short getShort(int index) {
        return (Short)this.array[index];
    }

    @Override
    public String getString(int index) {
        return (String)this.array[index];
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayRecord)) {
            return false;
        }
        ArrayRecord other = (ArrayRecord)o;
        return Arrays.equals(this.array, other.array);
    }

    public static ArrayRecord of(Object ... objects) {
        return new ArrayRecord(objects);
    }
}

