/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.ctc.wstx.dtd;

import java.util.Collection;
import shaded.com.ctc.wstx.dtd.ChoiceModel;
import shaded.com.ctc.wstx.dtd.ConcatModel;
import shaded.com.ctc.wstx.dtd.ContentSpec;
import shaded.com.ctc.wstx.dtd.LargePrefixedNameSet;
import shaded.com.ctc.wstx.dtd.ModelNode;
import shaded.com.ctc.wstx.dtd.OptionalModel;
import shaded.com.ctc.wstx.dtd.PrefixedNameSet;
import shaded.com.ctc.wstx.dtd.SmallPrefixedNameSet;
import shaded.com.ctc.wstx.dtd.StarModel;
import shaded.com.ctc.wstx.dtd.StructValidator;
import shaded.com.ctc.wstx.dtd.TokenContentSpec;
import shaded.com.ctc.wstx.util.ExceptionUtil;
import shaded.com.ctc.wstx.util.PrefixedName;

public class ChoiceContentSpec
extends ContentSpec {
    final boolean mNsAware;
    final boolean mHasMixed;
    final ContentSpec[] mContentSpecs;

    private ChoiceContentSpec(boolean nsAware, char arity, boolean mixed, ContentSpec[] specs) {
        super(arity);
        this.mNsAware = nsAware;
        this.mHasMixed = mixed;
        this.mContentSpecs = specs;
    }

    private ChoiceContentSpec(boolean nsAware, char arity, boolean mixed, Collection<ContentSpec> specs) {
        super(arity);
        this.mNsAware = nsAware;
        this.mHasMixed = mixed;
        this.mContentSpecs = new ContentSpec[specs.size()];
        specs.toArray(this.mContentSpecs);
    }

    public static ChoiceContentSpec constructChoice(boolean nsAware, char arity, Collection<ContentSpec> specs) {
        return new ChoiceContentSpec(nsAware, arity, false, specs);
    }

    public static ChoiceContentSpec constructMixed(boolean nsAware, Collection<ContentSpec> specs) {
        return new ChoiceContentSpec(nsAware, '*', true, specs);
    }

    @Override
    public StructValidator getSimpleValidator() {
        int i;
        ContentSpec[] specs = this.mContentSpecs;
        int len = specs.length;
        if (this.mHasMixed) {
            i = len;
        } else {
            for (i = 0; i < len && specs[i].isLeaf(); ++i) {
            }
        }
        if (i == len) {
            PrefixedNameSet keyset = ChoiceContentSpec.namesetFromSpecs(this.mNsAware, specs);
            return new Validator(this.mArity, keyset);
        }
        return null;
    }

    @Override
    public ModelNode rewrite() {
        ContentSpec[] specs = this.mContentSpecs;
        int len = specs.length;
        ModelNode[] models = new ModelNode[len];
        for (int i = 0; i < len; ++i) {
            models[i] = specs[i].rewrite();
        }
        ChoiceModel model = new ChoiceModel(models);
        if (this.mArity == '*') {
            return new StarModel(model);
        }
        if (this.mArity == '?') {
            return new OptionalModel(model);
        }
        if (this.mArity == '+') {
            return new ConcatModel(model, new StarModel(model.cloneModel()));
        }
        return model;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.mHasMixed) {
            sb.append("(#PCDATA | ");
        } else {
            sb.append('(');
        }
        for (int i = 0; i < this.mContentSpecs.length; ++i) {
            if (i > 0) {
                sb.append(" | ");
            }
            sb.append(this.mContentSpecs[i].toString());
        }
        sb.append(')');
        if (this.mArity != ' ') {
            sb.append(this.mArity);
        }
        return sb.toString();
    }

    protected static PrefixedNameSet namesetFromSpecs(boolean nsAware, ContentSpec[] specs) {
        int len = specs.length;
        PrefixedName[] nameArray = new PrefixedName[len];
        for (int i = 0; i < len; ++i) {
            nameArray[i] = ((TokenContentSpec)specs[i]).getName();
        }
        if (len < 5) {
            return new SmallPrefixedNameSet(nsAware, nameArray);
        }
        return new LargePrefixedNameSet(nsAware, nameArray);
    }

    static final class Validator
    extends StructValidator {
        final char mArity;
        final PrefixedNameSet mNames;
        int mCount = 0;

        public Validator(char arity, PrefixedNameSet names) {
            this.mArity = arity;
            this.mNames = names;
        }

        @Override
        public StructValidator newInstance() {
            return this.mArity == '*' ? this : new Validator(this.mArity, this.mNames);
        }

        @Override
        public String tryToValidate(PrefixedName elemName) {
            if (!this.mNames.contains(elemName)) {
                if (this.mNames.hasMultiple()) {
                    return "Expected one of (" + this.mNames.toString(" | ") + ")";
                }
                return "Expected <" + this.mNames.toString("") + ">";
            }
            if (++this.mCount > 1 && (this.mArity == '?' || this.mArity == ' ')) {
                if (this.mNames.hasMultiple()) {
                    return "Expected $END (already had one of [" + this.mNames.toString(" | ") + "]";
                }
                return "Expected $END (already had one <" + this.mNames.toString("") + ">]";
            }
            return null;
        }

        @Override
        public String fullyValid() {
            switch (this.mArity) {
                case '*': 
                case '?': {
                    return null;
                }
                case ' ': 
                case '+': {
                    if (this.mCount > 0) {
                        return null;
                    }
                    return "Expected " + (this.mArity == '+' ? "at least" : "") + " one of elements (" + this.mNames + ")";
                }
            }
            ExceptionUtil.throwGenericInternal();
            return null;
        }
    }
}

