/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.fs;

import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import shaded.org.apache.hadoop.fs.RemoteIterator;

public abstract class BatchedRemoteIterator<K, E>
implements RemoteIterator<E> {
    private K prevKey;
    private BatchedEntries<E> entries;
    private int idx;

    public BatchedRemoteIterator(K prevKey) {
        this.prevKey = prevKey;
        this.entries = null;
        this.idx = -1;
    }

    public abstract BatchedEntries<E> makeRequest(K var1) throws IOException;

    private void makeRequest() throws IOException {
        this.idx = 0;
        this.entries = null;
        this.entries = this.makeRequest(this.prevKey);
        if (this.entries.size() == 0) {
            this.entries = null;
        }
    }

    private void makeRequestIfNeeded() throws IOException {
        if (this.idx == -1) {
            this.makeRequest();
        } else if (this.entries != null && this.idx >= this.entries.size()) {
            if (!this.entries.hasMore()) {
                this.entries = null;
            } else {
                this.makeRequest();
            }
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        this.makeRequestIfNeeded();
        return this.entries != null;
    }

    public abstract K elementToPrevKey(E var1);

    @Override
    public E next() throws IOException {
        this.makeRequestIfNeeded();
        if (this.entries == null) {
            throw new NoSuchElementException();
        }
        E entry = this.entries.get(this.idx++);
        this.prevKey = this.elementToPrevKey(entry);
        return entry;
    }

    public static class BatchedListEntries<E>
    implements BatchedEntries<E> {
        private final List<E> entries;
        private final boolean hasMore;

        public BatchedListEntries(List<E> entries, boolean hasMore) {
            this.entries = entries;
            this.hasMore = hasMore;
        }

        @Override
        public E get(int i) {
            return this.entries.get(i);
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        @Override
        public boolean hasMore() {
            return this.hasMore;
        }
    }

    public static interface BatchedEntries<E> {
        public E get(int var1);

        public int size();

        public boolean hasMore();
    }
}

