/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.fs;

import java.io.DataInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.fs.ByteBufferPositionedReadable;
import shaded.org.apache.hadoop.fs.ByteBufferReadable;
import shaded.org.apache.hadoop.fs.ByteBufferUtil;
import shaded.org.apache.hadoop.fs.CanSetDropBehind;
import shaded.org.apache.hadoop.fs.CanSetReadahead;
import shaded.org.apache.hadoop.fs.CanUnbuffer;
import shaded.org.apache.hadoop.fs.HasEnhancedByteBufferAccess;
import shaded.org.apache.hadoop.fs.HasFileDescriptor;
import shaded.org.apache.hadoop.fs.PositionedReadable;
import shaded.org.apache.hadoop.fs.ReadOption;
import shaded.org.apache.hadoop.fs.Seekable;
import shaded.org.apache.hadoop.fs.StreamCapabilities;
import shaded.org.apache.hadoop.fs.StreamCapabilitiesPolicy;
import shaded.org.apache.hadoop.io.ByteBufferPool;
import shaded.org.apache.hadoop.util.IdentityHashStore;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FSDataInputStream
extends DataInputStream
implements Seekable,
PositionedReadable,
ByteBufferReadable,
HasFileDescriptor,
CanSetDropBehind,
CanSetReadahead,
HasEnhancedByteBufferAccess,
CanUnbuffer,
StreamCapabilities,
ByteBufferPositionedReadable {
    private final IdentityHashStore<ByteBuffer, ByteBufferPool> extendedReadBuffers = new IdentityHashStore(0);
    private static final EnumSet<ReadOption> EMPTY_READ_OPTIONS_SET = EnumSet.noneOf(ReadOption.class);

    public FSDataInputStream(InputStream in) {
        super(in);
        if (!(in instanceof Seekable) || !(in instanceof PositionedReadable)) {
            throw new IllegalArgumentException("In is not an instance of Seekable or PositionedReadable");
        }
    }

    @Override
    public void seek(long desired) throws IOException {
        ((Seekable)((Object)this.in)).seek(desired);
    }

    @Override
    public long getPos() throws IOException {
        return ((Seekable)((Object)this.in)).getPos();
    }

    @Override
    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        return ((PositionedReadable)((Object)this.in)).read(position, buffer, offset, length);
    }

    @Override
    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        ((PositionedReadable)((Object)this.in)).readFully(position, buffer, offset, length);
    }

    @Override
    public void readFully(long position, byte[] buffer) throws IOException {
        ((PositionedReadable)((Object)this.in)).readFully(position, buffer, 0, buffer.length);
    }

    @Override
    public boolean seekToNewSource(long targetPos) throws IOException {
        return ((Seekable)((Object)this.in)).seekToNewSource(targetPos);
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    public InputStream getWrappedStream() {
        return this.in;
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        if (this.in instanceof ByteBufferReadable) {
            return ((ByteBufferReadable)((Object)this.in)).read(buf);
        }
        throw new UnsupportedOperationException("Byte-buffer read unsupported by input stream");
    }

    @Override
    public FileDescriptor getFileDescriptor() throws IOException {
        if (this.in instanceof HasFileDescriptor) {
            return ((HasFileDescriptor)((Object)this.in)).getFileDescriptor();
        }
        if (this.in instanceof FileInputStream) {
            return ((FileInputStream)this.in).getFD();
        }
        return null;
    }

    @Override
    public void setReadahead(Long readahead) throws IOException, UnsupportedOperationException {
        try {
            ((CanSetReadahead)((Object)this.in)).setReadahead(readahead);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("this stream does not support setting the readahead caching strategy.");
        }
    }

    @Override
    public void setDropBehind(Boolean dropBehind) throws IOException, UnsupportedOperationException {
        try {
            ((CanSetDropBehind)((Object)this.in)).setDropBehind(dropBehind);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("this stream does not support setting the drop-behind caching setting.");
        }
    }

    @Override
    public ByteBuffer read(ByteBufferPool bufferPool, int maxLength, EnumSet<ReadOption> opts) throws IOException, UnsupportedOperationException {
        try {
            return ((HasEnhancedByteBufferAccess)((Object)this.in)).read(bufferPool, maxLength, opts);
        }
        catch (ClassCastException e) {
            ByteBuffer buffer = ByteBufferUtil.fallbackRead(this, bufferPool, maxLength);
            if (buffer != null) {
                this.extendedReadBuffers.put(buffer, bufferPool);
            }
            return buffer;
        }
    }

    public final ByteBuffer read(ByteBufferPool bufferPool, int maxLength) throws IOException, UnsupportedOperationException {
        return this.read(bufferPool, maxLength, EMPTY_READ_OPTIONS_SET);
    }

    @Override
    public void releaseBuffer(ByteBuffer buffer) {
        try {
            ((HasEnhancedByteBufferAccess)((Object)this.in)).releaseBuffer(buffer);
        }
        catch (ClassCastException e) {
            ByteBufferPool bufferPool = this.extendedReadBuffers.remove(buffer);
            if (bufferPool == null) {
                throw new IllegalArgumentException("tried to release a buffer that was not created by this stream.");
            }
            bufferPool.putBuffer(buffer);
        }
    }

    @Override
    public void unbuffer() {
        StreamCapabilitiesPolicy.unbuffer(this.in);
    }

    @Override
    public boolean hasCapability(String capability) {
        if (this.in instanceof StreamCapabilities) {
            return ((StreamCapabilities)((Object)this.in)).hasCapability(capability);
        }
        return false;
    }

    public String toString() {
        return super.toString() + ": " + this.in;
    }

    @Override
    public int read(long position, ByteBuffer buf) throws IOException {
        if (this.in instanceof ByteBufferPositionedReadable) {
            return ((ByteBufferPositionedReadable)((Object)this.in)).read(position, buf);
        }
        throw new UnsupportedOperationException("Byte-buffer pread unsupported by input stream");
    }
}

