/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.fs;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.FileSystem;
import shaded.org.apache.hadoop.fs.Path;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class FsUrlConnection
extends URLConnection {
    private static final Logger LOG = LoggerFactory.getLogger(FsUrlConnection.class);
    private Configuration conf;
    private InputStream is;

    FsUrlConnection(Configuration conf, URL url) {
        super(url);
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"null conf argument");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"null url argument");
        this.conf = conf;
    }

    @Override
    public void connect() throws IOException {
        Preconditions.checkState((this.is == null ? 1 : 0) != 0, (Object)"Already connected");
        try {
            LOG.debug("Connecting to {}", (Object)this.url);
            FileSystem fs = FileSystem.get(this.url.toURI(), this.conf);
            this.is = fs.open(new Path(this.url.getPath()));
        }
        catch (URISyntaxException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.is == null) {
            this.connect();
        }
        return this.is;
    }
}

