/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.fs;

import java.io.IOException;
import shaded.org.apache.hadoop.fs.Path;

public class PathIOException
extends IOException {
    static final long serialVersionUID = 0L;
    private static final String EIO = "Input/output error";
    private String operation;
    private String path;
    private String fullyQualifiedPath;
    private String targetPath;

    public PathIOException(String path) {
        this(path, EIO);
    }

    public PathIOException(String path, Throwable cause) {
        this(path, EIO, cause);
    }

    public PathIOException(String path, String error) {
        super(error);
        this.path = path;
    }

    protected PathIOException(String path, String error, Throwable cause) {
        super(error, cause);
        this.path = path;
    }

    public PathIOException withFullyQualifiedPath(String fqPath) {
        this.fullyQualifiedPath = fqPath;
        return this;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        if (this.operation != null) {
            message.append(this.operation + " ");
        }
        message.append(this.formatPath(this.path));
        if (this.targetPath != null) {
            message.append(" to " + this.formatPath(this.targetPath));
        }
        message.append(": " + super.getMessage());
        if (this.getCause() != null) {
            message.append(": " + this.getCause().getMessage());
        }
        if (this.fullyQualifiedPath != null && !this.fullyQualifiedPath.equals(this.path)) {
            message.append(": ").append(this.formatPath(this.fullyQualifiedPath));
        }
        return message.toString();
    }

    public Path getPath() {
        return new Path(this.path);
    }

    public Path getTargetPath() {
        return this.targetPath != null ? new Path(this.targetPath) : null;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    private String formatPath(String path) {
        return "`" + path + "'";
    }
}

