/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.fs.permission;

import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public enum FsAction {
    NONE("---"),
    EXECUTE("--x"),
    WRITE("-w-"),
    WRITE_EXECUTE("-wx"),
    READ("r--"),
    READ_EXECUTE("r-x"),
    READ_WRITE("rw-"),
    ALL("rwx");

    private static final FsAction[] vals;
    public final String SYMBOL;

    private FsAction(String s) {
        this.SYMBOL = s;
    }

    public boolean implies(FsAction that) {
        if (that != null) {
            return (this.ordinal() & that.ordinal()) == that.ordinal();
        }
        return false;
    }

    public FsAction and(FsAction that) {
        return vals[this.ordinal() & that.ordinal()];
    }

    public FsAction or(FsAction that) {
        return vals[this.ordinal() | that.ordinal()];
    }

    public FsAction not() {
        return vals[7 - this.ordinal()];
    }

    public static FsAction getFsAction(String permission) {
        for (FsAction fsAction : vals) {
            if (!fsAction.SYMBOL.equals(permission)) continue;
            return fsAction;
        }
        return null;
    }

    static {
        vals = FsAction.values();
    }
}

