/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.ha;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.conf.Configured;
import shaded.org.apache.hadoop.ha.BadFencingConfigurationException;
import shaded.org.apache.hadoop.ha.FenceMethod;
import shaded.org.apache.hadoop.ha.HAServiceProtocol;
import shaded.org.apache.hadoop.ha.HAServiceTarget;
import shaded.org.apache.hadoop.ha.StreamPumper;
import shaded.org.apache.hadoop.util.Shell;

public class ShellCommandFencer
extends Configured
implements FenceMethod {
    private static final int ABBREV_LENGTH = 20;
    private static final String TARGET_PREFIX = "target_";
    private static final String SOURCE_PREFIX = "source_";
    private static final String ARG_DELIMITER = ",";
    @VisibleForTesting
    static Logger LOG = LoggerFactory.getLogger(ShellCommandFencer.class);

    @Override
    public void checkArgs(String args) throws BadFencingConfigurationException {
        if (args == null || args.isEmpty()) {
            throw new BadFencingConfigurationException("No argument passed to 'shell' fencing method");
        }
    }

    @Override
    public boolean tryFence(HAServiceTarget target, String args) {
        int rc;
        Process p;
        String cmd = this.parseArgs(target.getTransitionTargetHAStatus(), args);
        ProcessBuilder builder = !Shell.WINDOWS ? new ProcessBuilder("bash", "-e", "-c", cmd) : new ProcessBuilder("cmd.exe", "/c", cmd);
        this.setConfAsEnvVars(builder.environment());
        this.addTargetInfoAsEnvVars(target, builder.environment());
        try {
            p = builder.start();
            p.getOutputStream().close();
        }
        catch (IOException e) {
            LOG.warn("Unable to execute " + cmd, (Throwable)e);
            return false;
        }
        String pid = ShellCommandFencer.tryGetPid(p);
        LOG.info("Launched fencing command '" + cmd + "' with " + (pid != null ? "pid " + pid : "unknown pid"));
        String logPrefix = ShellCommandFencer.abbreviate(cmd, 20);
        if (pid != null) {
            logPrefix = "[PID " + pid + "] " + logPrefix;
        }
        StreamPumper errPumper = new StreamPumper(LOG, logPrefix, p.getErrorStream(), StreamPumper.StreamType.STDERR);
        errPumper.start();
        StreamPumper outPumper = new StreamPumper(LOG, logPrefix, p.getInputStream(), StreamPumper.StreamType.STDOUT);
        outPumper.start();
        try {
            rc = p.waitFor();
            errPumper.join();
            outPumper.join();
        }
        catch (InterruptedException ie) {
            LOG.warn("Interrupted while waiting for fencing command: " + cmd);
            return false;
        }
        return rc == 0;
    }

    private String parseArgs(HAServiceProtocol.HAServiceState state, String cmd) {
        String[] args = cmd.split(ARG_DELIMITER);
        if (args.length == 1) {
            return args[0];
        }
        if (args.length > 2) {
            throw new IllegalArgumentException("Expecting arguments size of at most two, getting " + Arrays.asList(args));
        }
        if (HAServiceProtocol.HAServiceState.ACTIVE.equals((Object)state)) {
            return args[0];
        }
        if (HAServiceProtocol.HAServiceState.STANDBY.equals((Object)state)) {
            return args[1];
        }
        throw new IllegalArgumentException("Unexpected HA service state:" + (Object)((Object)state));
    }

    static String abbreviate(String cmd, int len) {
        if (cmd.length() > len && len >= 5) {
            int firstHalf = (len - 3) / 2;
            int rem = len - firstHalf - 3;
            return cmd.substring(0, firstHalf) + "..." + cmd.substring(cmd.length() - rem);
        }
        return cmd;
    }

    private static String tryGetPid(Process p) {
        try {
            Class<?> clazz = p.getClass();
            if (clazz.getName().equals("java.lang.UNIXProcess")) {
                Field f = clazz.getDeclaredField("pid");
                f.setAccessible(true);
                return String.valueOf(f.getInt(p));
            }
            LOG.trace("Unable to determine pid for " + p + " since it is not a UNIXProcess");
            return null;
        }
        catch (Throwable t) {
            LOG.trace("Unable to determine pid for " + p, t);
            return null;
        }
    }

    private void setConfAsEnvVars(Map<String, String> env) {
        for (Map.Entry<String, String> pair : this.getConf()) {
            env.put(pair.getKey().replace('.', '_'), pair.getValue());
        }
    }

    private void addTargetInfoAsEnvVars(HAServiceTarget target, Map<String, String> environment) {
        String prefix;
        HAServiceProtocol.HAServiceState targetState = target.getTransitionTargetHAStatus();
        if (targetState == null || HAServiceProtocol.HAServiceState.ACTIVE.equals((Object)targetState)) {
            prefix = TARGET_PREFIX;
        } else if (HAServiceProtocol.HAServiceState.STANDBY.equals((Object)targetState)) {
            prefix = SOURCE_PREFIX;
        } else {
            throw new IllegalArgumentException("Unexpected HA service state:" + (Object)((Object)targetState));
        }
        for (Map.Entry<String, String> e : target.getFencingParameters().entrySet()) {
            String key = prefix + e.getKey();
            key = key.replace('.', '_');
            environment.put(key, e.getValue());
        }
    }
}

