/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.protocolPB;

import com.google.common.primitives.Longs;
import com.google.protobuf.ByteString;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.fs.StorageType;
import shaded.org.apache.hadoop.hdfs.client.BlockReportOptions;
import shaded.org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import shaded.org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import shaded.org.apache.hadoop.hdfs.protocol.DatanodeLocalInfo;
import shaded.org.apache.hadoop.hdfs.protocol.DatanodeVolumeInfo;
import shaded.org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import shaded.org.apache.hadoop.hdfs.protocol.HdfsBlocksMetadata;
import shaded.org.apache.hadoop.hdfs.protocol.proto.ClientDatanodeProtocolProtos;
import shaded.org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import shaded.org.apache.hadoop.hdfs.protocol.proto.ReconfigurationProtocolProtos;
import shaded.org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolPB;
import shaded.org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import shaded.org.apache.hadoop.hdfs.protocolPB.ReconfigurationProtocolServerSideUtils;
import shaded.org.apache.hadoop.security.proto.SecurityProtos;
import shaded.org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public class ClientDatanodeProtocolServerSideTranslatorPB
implements ClientDatanodeProtocolPB {
    private static final ClientDatanodeProtocolProtos.RefreshNamenodesResponseProto REFRESH_NAMENODE_RESP = ClientDatanodeProtocolProtos.RefreshNamenodesResponseProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.DeleteBlockPoolResponseProto DELETE_BLOCKPOOL_RESP = ClientDatanodeProtocolProtos.DeleteBlockPoolResponseProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.ShutdownDatanodeResponseProto SHUTDOWN_DATANODE_RESP = ClientDatanodeProtocolProtos.ShutdownDatanodeResponseProto.newBuilder().build();
    private static final ReconfigurationProtocolProtos.StartReconfigurationResponseProto START_RECONFIG_RESP = ReconfigurationProtocolProtos.StartReconfigurationResponseProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.TriggerBlockReportResponseProto TRIGGER_BLOCK_REPORT_RESP = ClientDatanodeProtocolProtos.TriggerBlockReportResponseProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.EvictWritersResponseProto EVICT_WRITERS_RESP = ClientDatanodeProtocolProtos.EvictWritersResponseProto.newBuilder().build();
    private final ClientDatanodeProtocol impl;

    public ClientDatanodeProtocolServerSideTranslatorPB(ClientDatanodeProtocol impl) {
        this.impl = impl;
    }

    public ClientDatanodeProtocolProtos.GetReplicaVisibleLengthResponseProto getReplicaVisibleLength(RpcController unused, ClientDatanodeProtocolProtos.GetReplicaVisibleLengthRequestProto request) throws ServiceException {
        long len;
        try {
            len = this.impl.getReplicaVisibleLength(PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)request.getBlock()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return ClientDatanodeProtocolProtos.GetReplicaVisibleLengthResponseProto.newBuilder().setLength(len).build();
    }

    public ClientDatanodeProtocolProtos.RefreshNamenodesResponseProto refreshNamenodes(RpcController unused, ClientDatanodeProtocolProtos.RefreshNamenodesRequestProto request) throws ServiceException {
        try {
            this.impl.refreshNamenodes();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return REFRESH_NAMENODE_RESP;
    }

    public ClientDatanodeProtocolProtos.DeleteBlockPoolResponseProto deleteBlockPool(RpcController unused, ClientDatanodeProtocolProtos.DeleteBlockPoolRequestProto request) throws ServiceException {
        try {
            this.impl.deleteBlockPool(request.getBlockPool(), request.getForce());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return DELETE_BLOCKPOOL_RESP;
    }

    public ClientDatanodeProtocolProtos.GetBlockLocalPathInfoResponseProto getBlockLocalPathInfo(RpcController unused, ClientDatanodeProtocolProtos.GetBlockLocalPathInfoRequestProto request) throws ServiceException {
        BlockLocalPathInfo resp;
        try {
            resp = this.impl.getBlockLocalPathInfo(PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)request.getBlock()), PBHelperClient.convert((SecurityProtos.TokenProto)request.getToken()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return ClientDatanodeProtocolProtos.GetBlockLocalPathInfoResponseProto.newBuilder().setBlock(PBHelperClient.convert((ExtendedBlock)resp.getBlock())).setLocalPath(resp.getBlockPath()).setLocalMetaPath(resp.getMetaPath()).build();
    }

    public ClientDatanodeProtocolProtos.GetHdfsBlockLocationsResponseProto getHdfsBlockLocations(RpcController controller, ClientDatanodeProtocolProtos.GetHdfsBlockLocationsRequestProto request) throws ServiceException {
        HdfsBlocksMetadata resp;
        try {
            String poolId = request.getBlockPoolId();
            ArrayList<Token> tokens = new ArrayList<Token>(request.getTokensCount());
            for (SecurityProtos.TokenProto b : request.getTokensList()) {
                tokens.add(PBHelperClient.convert((SecurityProtos.TokenProto)b));
            }
            long[] blockIds = Longs.toArray((Collection)request.getBlockIdsList());
            resp = this.impl.getHdfsBlocksMetadata(poolId, blockIds, tokens);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        ArrayList<ByteString> volumeIdsByteStrings = new ArrayList<ByteString>(resp.getVolumeIds().size());
        for (byte[] b : resp.getVolumeIds()) {
            volumeIdsByteStrings.add(ByteString.copyFrom((byte[])b));
        }
        ClientDatanodeProtocolProtos.GetHdfsBlockLocationsResponseProto.Builder builder = ClientDatanodeProtocolProtos.GetHdfsBlockLocationsResponseProto.newBuilder();
        builder.addAllVolumeIds(volumeIdsByteStrings);
        builder.addAllVolumeIndexes((Iterable)resp.getVolumeIndexes());
        return builder.build();
    }

    public ClientDatanodeProtocolProtos.ShutdownDatanodeResponseProto shutdownDatanode(RpcController unused, ClientDatanodeProtocolProtos.ShutdownDatanodeRequestProto request) throws ServiceException {
        try {
            this.impl.shutdownDatanode(request.getForUpgrade());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return SHUTDOWN_DATANODE_RESP;
    }

    public ClientDatanodeProtocolProtos.EvictWritersResponseProto evictWriters(RpcController unused, ClientDatanodeProtocolProtos.EvictWritersRequestProto request) throws ServiceException {
        try {
            this.impl.evictWriters();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return EVICT_WRITERS_RESP;
    }

    public ClientDatanodeProtocolProtos.GetDatanodeInfoResponseProto getDatanodeInfo(RpcController unused, ClientDatanodeProtocolProtos.GetDatanodeInfoRequestProto request) throws ServiceException {
        ClientDatanodeProtocolProtos.GetDatanodeInfoResponseProto res;
        try {
            res = ClientDatanodeProtocolProtos.GetDatanodeInfoResponseProto.newBuilder().setLocalInfo(PBHelperClient.convert((DatanodeLocalInfo)this.impl.getDatanodeInfo())).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return res;
    }

    public ReconfigurationProtocolProtos.StartReconfigurationResponseProto startReconfiguration(RpcController unused, ReconfigurationProtocolProtos.StartReconfigurationRequestProto request) throws ServiceException {
        try {
            this.impl.startReconfiguration();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return START_RECONFIG_RESP;
    }

    public ReconfigurationProtocolProtos.ListReconfigurablePropertiesResponseProto listReconfigurableProperties(RpcController controller, ReconfigurationProtocolProtos.ListReconfigurablePropertiesRequestProto request) throws ServiceException {
        try {
            return ReconfigurationProtocolServerSideUtils.listReconfigurableProperties(this.impl.listReconfigurableProperties());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ReconfigurationProtocolProtos.GetReconfigurationStatusResponseProto getReconfigurationStatus(RpcController unused, ReconfigurationProtocolProtos.GetReconfigurationStatusRequestProto request) throws ServiceException {
        try {
            return ReconfigurationProtocolServerSideUtils.getReconfigurationStatus(this.impl.getReconfigurationStatus());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientDatanodeProtocolProtos.TriggerBlockReportResponseProto triggerBlockReport(RpcController unused, ClientDatanodeProtocolProtos.TriggerBlockReportRequestProto request) throws ServiceException {
        try {
            this.impl.triggerBlockReport(new BlockReportOptions.Factory().setIncremental(request.getIncremental()).build());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return TRIGGER_BLOCK_REPORT_RESP;
    }

    public ClientDatanodeProtocolProtos.GetBalancerBandwidthResponseProto getBalancerBandwidth(RpcController controller, ClientDatanodeProtocolProtos.GetBalancerBandwidthRequestProto request) throws ServiceException {
        long bandwidth;
        try {
            bandwidth = this.impl.getBalancerBandwidth();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return ClientDatanodeProtocolProtos.GetBalancerBandwidthResponseProto.newBuilder().setBandwidth(bandwidth).build();
    }

    public ClientDatanodeProtocolProtos.GetVolumeReportResponseProto getVolumeReport(RpcController controller, ClientDatanodeProtocolProtos.GetVolumeReportRequestProto request) throws ServiceException {
        try {
            ClientDatanodeProtocolProtos.GetVolumeReportResponseProto.Builder builder = ClientDatanodeProtocolProtos.GetVolumeReportResponseProto.newBuilder();
            List volumeReport = this.impl.getVolumeReport();
            for (DatanodeVolumeInfo info : volumeReport) {
                builder.addVolumeInfo(HdfsProtos.DatanodeVolumeInfoProto.newBuilder().setPath(info.getPath()).setFreeSpace(info.getFreeSpace()).setNumBlocks(info.getNumBlocks()).setReservedSpace(info.getReservedSpace()).setReservedSpaceForReplicas(info.getReservedSpaceForReplicas()).setStorageType(PBHelperClient.convertStorageType((StorageType)info.getStorageType())).setUsedSpace(info.getUsedSpace()));
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

