/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.SocketFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import shaded.org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import shaded.org.apache.hadoop.hdfs.protocol.proto.InterDatanodeProtocolProtos;
import shaded.org.apache.hadoop.hdfs.protocolPB.InterDatanodeProtocolPB;
import shaded.org.apache.hadoop.hdfs.protocolPB.PBHelper;
import shaded.org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import shaded.org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import shaded.org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import shaded.org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import shaded.org.apache.hadoop.ipc.ProtobufHelper;
import shaded.org.apache.hadoop.ipc.ProtobufRpcEngine;
import shaded.org.apache.hadoop.ipc.ProtocolMetaInterface;
import shaded.org.apache.hadoop.ipc.RPC;
import shaded.org.apache.hadoop.ipc.RpcClientUtil;
import shaded.org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class InterDatanodeProtocolTranslatorPB
implements ProtocolMetaInterface,
InterDatanodeProtocol,
Closeable {
    private static final RpcController NULL_CONTROLLER = null;
    private final InterDatanodeProtocolPB rpcProxy;

    public InterDatanodeProtocolTranslatorPB(InetSocketAddress addr, UserGroupInformation ugi, Configuration conf, SocketFactory factory, int socketTimeout) throws IOException {
        RPC.setProtocolEngine(conf, InterDatanodeProtocolPB.class, ProtobufRpcEngine.class);
        this.rpcProxy = RPC.getProxy(InterDatanodeProtocolPB.class, RPC.getProtocolVersion(InterDatanodeProtocolPB.class), addr, ugi, conf, factory, socketTimeout);
    }

    @Override
    public void close() {
        RPC.stopProxy(this.rpcProxy);
    }

    @Override
    public ReplicaRecoveryInfo initReplicaRecovery(BlockRecoveryCommand.RecoveringBlock rBlock) throws IOException {
        InterDatanodeProtocolProtos.InitReplicaRecoveryResponseProto resp;
        InterDatanodeProtocolProtos.InitReplicaRecoveryRequestProto req = InterDatanodeProtocolProtos.InitReplicaRecoveryRequestProto.newBuilder().setBlock(PBHelper.convert(rBlock)).build();
        try {
            resp = this.rpcProxy.initReplicaRecovery(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
        if (!resp.getReplicaFound()) {
            return null;
        }
        if (!resp.hasBlock() || !resp.hasState()) {
            throw new IOException("Replica was found but missing fields. Req: " + req + "\n" + "Resp: " + resp);
        }
        HdfsProtos.BlockProto b = resp.getBlock();
        return new ReplicaRecoveryInfo(b.getBlockId(), b.getNumBytes(), b.getGenStamp(), PBHelper.convert(resp.getState()));
    }

    @Override
    public String updateReplicaUnderRecovery(ExtendedBlock oldBlock, long recoveryId, long newBlockId, long newLength) throws IOException {
        InterDatanodeProtocolProtos.UpdateReplicaUnderRecoveryRequestProto req = InterDatanodeProtocolProtos.UpdateReplicaUnderRecoveryRequestProto.newBuilder().setBlock(PBHelperClient.convert((ExtendedBlock)oldBlock)).setNewLength(newLength).setNewBlockId(newBlockId).setRecoveryId(recoveryId).build();
        try {
            return this.rpcProxy.updateReplicaUnderRecovery(NULL_CONTROLLER, req).getStorageUuid();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported(this.rpcProxy, InterDatanodeProtocolPB.class, RPC.RpcKind.RPC_PROTOCOL_BUFFER, RPC.getProtocolVersion(InterDatanodeProtocolPB.class), methodName);
    }
}

