/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.balancer;

import java.io.Closeable;
import java.io.IOException;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import shaded.org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataEncryptionKeyFactory;
import shaded.org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import shaded.org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import shaded.org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import shaded.org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import shaded.org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import shaded.org.apache.hadoop.security.token.Token;
import shaded.org.apache.hadoop.util.Daemon;
import shaded.org.apache.hadoop.util.StringUtils;
import shaded.org.apache.hadoop.util.Timer;

@InterfaceAudience.Private
public class KeyManager
implements Closeable,
DataEncryptionKeyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(KeyManager.class);
    private final NamenodeProtocol namenode;
    private final boolean isBlockTokenEnabled;
    private final boolean encryptDataTransfer;
    private boolean shouldRun;
    private final BlockTokenSecretManager blockTokenSecretManager;
    private final BlockKeyUpdater blockKeyUpdater;
    private DataEncryptionKey encryptionKey;
    private Timer timer;

    public KeyManager(String blockpoolID, NamenodeProtocol namenode, boolean encryptDataTransfer, Configuration conf) throws IOException {
        this.namenode = namenode;
        this.encryptDataTransfer = encryptDataTransfer;
        this.timer = new Timer();
        ExportedBlockKeys keys = namenode.getBlockKeys();
        this.isBlockTokenEnabled = keys.isBlockTokenEnabled();
        if (this.isBlockTokenEnabled) {
            long updateInterval = keys.getKeyUpdateInterval();
            long tokenLifetime = keys.getTokenLifetime();
            LOG.info("Block token params received from NN: update interval=" + StringUtils.formatTime(updateInterval) + ", token lifetime=" + StringUtils.formatTime(tokenLifetime));
            String encryptionAlgorithm = conf.get("dfs.encrypt.data.transfer.algorithm");
            this.blockTokenSecretManager = new BlockTokenSecretManager(updateInterval, tokenLifetime, blockpoolID, encryptionAlgorithm);
            this.blockTokenSecretManager.addKeys(keys);
            this.blockKeyUpdater = new BlockKeyUpdater(updateInterval / 4L);
            this.shouldRun = true;
        } else {
            this.blockTokenSecretManager = null;
            this.blockKeyUpdater = null;
        }
    }

    public void startBlockKeyUpdater() {
        if (this.blockKeyUpdater != null) {
            this.blockKeyUpdater.daemon.start();
        }
    }

    public Token<BlockTokenIdentifier> getAccessToken(ExtendedBlock eb) throws IOException {
        if (!this.isBlockTokenEnabled) {
            return BlockTokenSecretManager.DUMMY_TOKEN;
        }
        if (!this.shouldRun) {
            throw new IOException("Cannot get access token since BlockKeyUpdater is not running");
        }
        return this.blockTokenSecretManager.generateToken(null, eb, EnumSet.of(BlockTokenIdentifier.AccessMode.REPLACE, BlockTokenIdentifier.AccessMode.COPY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataEncryptionKey newDataEncryptionKey() {
        if (this.encryptDataTransfer) {
            KeyManager keyManager = this;
            synchronized (keyManager) {
                if (this.encryptionKey == null || this.encryptionKey.expiryDate < this.timer.now()) {
                    LOG.debug("Generating new data encryption key because current key " + (this.encryptionKey == null ? "is null." : "expired on " + this.encryptionKey.expiryDate));
                    this.encryptionKey = this.blockTokenSecretManager.generateDataEncryptionKey();
                }
                return this.encryptionKey;
            }
        }
        return null;
    }

    @Override
    public void close() {
        this.shouldRun = false;
        try {
            if (this.blockKeyUpdater != null) {
                this.blockKeyUpdater.daemon.interrupt();
            }
        }
        catch (Exception e) {
            LOG.warn("Exception shutting down access key updater thread", (Throwable)e);
        }
    }

    class BlockKeyUpdater
    implements Runnable,
    Closeable {
        private final Daemon daemon = new Daemon(this);
        private final long sleepInterval;

        BlockKeyUpdater(long sleepInterval) {
            this.sleepInterval = sleepInterval;
            LOG.info("Update block keys every " + StringUtils.formatTime(sleepInterval));
        }

        @Override
        public void run() {
            try {
                while (KeyManager.this.shouldRun) {
                    try {
                        KeyManager.this.blockTokenSecretManager.addKeys(KeyManager.this.namenode.getBlockKeys());
                    }
                    catch (IOException e) {
                        LOG.error("Failed to set keys", (Throwable)e);
                    }
                    Thread.sleep(this.sleepInterval);
                }
            }
            catch (InterruptedException e) {
                LOG.debug("InterruptedException in block key updater thread", (Throwable)e);
            }
            catch (Throwable e) {
                LOG.error("Exception in block key updater thread", e);
                KeyManager.this.shouldRun = false;
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.daemon.interrupt();
            }
            catch (Exception e) {
                LOG.warn("Exception shutting down key updater thread", (Throwable)e);
            }
        }
    }
}

