/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.blockmanagement;

import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.hdfs.protocol.Block;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import shaded.org.apache.hadoop.util.SequentialNumber;

@InterfaceAudience.Private
public class SequentialBlockIdGenerator
extends SequentialNumber {
    public static final long LAST_RESERVED_BLOCK_ID = 0x40000000L;
    private final BlockManager blockManager;

    SequentialBlockIdGenerator(BlockManager blockManagerRef) {
        super(0x40000000L);
        this.blockManager = blockManagerRef;
    }

    @Override
    public long nextValue() {
        Block b = new Block(super.nextValue());
        while (this.isValidBlock(b)) {
            b.setBlockId(super.nextValue());
        }
        return b.getBlockId();
    }

    private boolean isValidBlock(Block b) {
        BlockInfo bi = this.blockManager.getStoredBlock(b);
        return bi != null && bi.getBlockCollectionId() != -1L;
    }
}

