/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.datanode;

import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.hdfs.server.common.Util;
import shaded.org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import shaded.org.apache.hadoop.hdfs.server.datanode.fsdataset.DataNodeVolumeMetrics;
import shaded.org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import shaded.org.apache.hadoop.util.Time;

@InterfaceAudience.Private
class ProfilingFileIoEvents {
    static final Log LOG = LogFactory.getLog(ProfilingFileIoEvents.class);
    private final boolean isEnabled;
    private final int sampleRangeMax;

    public ProfilingFileIoEvents(@Nullable Configuration conf) {
        if (conf != null) {
            int fileIOSamplingPercentage = conf.getInt("dfs.datanode.fileio.profiling.sampling.percentage", 0);
            this.isEnabled = Util.isDiskStatsEnabled(fileIOSamplingPercentage);
            if (fileIOSamplingPercentage > 100) {
                LOG.warn((Object)"dfs.datanode.fileio.profiling.sampling.percentage value cannot be more than 100. Setting value to 100");
                fileIOSamplingPercentage = 100;
            }
            this.sampleRangeMax = (int)((double)fileIOSamplingPercentage / 100.0 * 2.147483647E9);
        } else {
            this.isEnabled = false;
            this.sampleRangeMax = 0;
        }
    }

    public long beforeMetadataOp(@Nullable FsVolumeSpi volume, FileIoProvider.OPERATION op) {
        DataNodeVolumeMetrics metrics;
        if (this.isEnabled && (metrics = this.getVolumeMetrics(volume)) != null) {
            return Time.monotonicNow();
        }
        return 0L;
    }

    public void afterMetadataOp(@Nullable FsVolumeSpi volume, FileIoProvider.OPERATION op, long begin) {
        DataNodeVolumeMetrics metrics;
        if (this.isEnabled && (metrics = this.getVolumeMetrics(volume)) != null) {
            metrics.addMetadastaOperationLatency(Time.monotonicNow() - begin);
        }
    }

    public long beforeFileIo(@Nullable FsVolumeSpi volume, FileIoProvider.OPERATION op, long len) {
        DataNodeVolumeMetrics metrics;
        if (this.isEnabled && ThreadLocalRandom.current().nextInt() < this.sampleRangeMax && (metrics = this.getVolumeMetrics(volume)) != null) {
            return Time.monotonicNow();
        }
        return 0L;
    }

    public void afterFileIo(@Nullable FsVolumeSpi volume, FileIoProvider.OPERATION op, long begin, long len) {
        DataNodeVolumeMetrics metrics;
        if (this.isEnabled && begin != 0L && (metrics = this.getVolumeMetrics(volume)) != null) {
            long latency = Time.monotonicNow() - begin;
            metrics.addDataFileIoLatency(latency);
            switch (op) {
                case SYNC: {
                    metrics.addSyncIoLatency(latency);
                    break;
                }
                case FLUSH: {
                    metrics.addFlushIoLatency(latency);
                    break;
                }
                case READ: {
                    metrics.addReadIoLatency(latency);
                    break;
                }
                case WRITE: {
                    metrics.addWriteIoLatency(latency);
                    break;
                }
            }
        }
    }

    public void onFailure(@Nullable FsVolumeSpi volume, long begin) {
        DataNodeVolumeMetrics metrics;
        if (this.isEnabled && (metrics = this.getVolumeMetrics(volume)) != null) {
            metrics.addFileIoError(Time.monotonicNow() - begin);
        }
    }

    private DataNodeVolumeMetrics getVolumeMetrics(FsVolumeSpi volume) {
        if (this.isEnabled && volume != null) {
            return volume.getMetrics();
        }
        return null;
    }
}

