/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import shaded.org.apache.hadoop.hdfs.server.namenode.NameNode;
import shaded.org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import shaded.org.apache.hadoop.security.UserGroupInformation;
import shaded.org.apache.hadoop.security.token.Token;

public class CancelDelegationTokenServlet
extends DfsServlet {
    private static final Log LOG = LogFactory.getLog(CancelDelegationTokenServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserGroupInformation ugi;
        ServletContext context = this.getServletContext();
        Configuration conf = NameNodeHttpServer.getConfFromContext(context);
        try {
            ugi = this.getUGI(req, conf);
        }
        catch (IOException ioe) {
            LOG.info((Object)("Request for token received with no authentication from " + req.getRemoteAddr()), (Throwable)ioe);
            resp.sendError(403, "Unable to identify or authenticate user");
            return;
        }
        final NameNode nn = NameNodeHttpServer.getNameNodeFromContext(context);
        String tokenString = req.getParameter("token");
        if (tokenString == null) {
            resp.sendError(300, "Token to renew not specified");
        }
        final Token token = new Token();
        token.decodeFromUrlString(tokenString);
        try {
            ugi.doAs(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    nn.getRpcServer().cancelDelegationToken(token);
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOG.info((Object)"Exception while cancelling token. Re-throwing. ", (Throwable)e);
            resp.sendError(500, e.getMessage());
        }
    }
}

