/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.ha.HAServiceProtocol;
import shaded.org.apache.hadoop.hdfs.protocol.ClientProtocol;
import shaded.org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import shaded.org.apache.hadoop.hdfs.server.namenode.ha.ObserverReadProxyProvider;
import shaded.org.apache.hadoop.hdfs.server.namenode.ha.ReadOnly;
import shaded.org.apache.hadoop.ipc.AlignmentContext;
import shaded.org.apache.hadoop.ipc.RetriableException;
import shaded.org.apache.hadoop.ipc.StandbyException;
import shaded.org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class GlobalStateIdContext
implements AlignmentContext {
    private static final long ESTIMATED_TRANSACTIONS_PER_SECOND = 10000L;
    private static final float ESTIMATED_SERVER_TIME_MULTIPLIER = 0.8f;
    private final FSNamesystem namesystem;
    private final HashSet<String> coordinatedMethods;

    GlobalStateIdContext(FSNamesystem namesystem) {
        this.namesystem = namesystem;
        this.coordinatedMethods = new HashSet();
        for (Method method : ClientProtocol.class.getDeclaredMethods()) {
            for (Annotation anno : method.getAnnotations()) {
                if (!(anno instanceof ReadOnly) || !((ReadOnly)anno).isCoordinated()) continue;
                this.coordinatedMethods.add(method.getName());
            }
        }
    }

    @Override
    public void updateResponseState(RpcHeaderProtos.RpcResponseHeaderProto.Builder header) {
        header.setStateId(this.getLastSeenStateId());
    }

    @Override
    public void receiveResponseState(RpcHeaderProtos.RpcResponseHeaderProto header) {
    }

    @Override
    public void updateRequestState(RpcHeaderProtos.RpcRequestHeaderProto.Builder header) {
    }

    @Override
    public long receiveRequestState(RpcHeaderProtos.RpcRequestHeaderProto header, long clientWaitTime) throws IOException {
        if (!header.hasStateId() && HAServiceProtocol.HAServiceState.OBSERVER.equals((Object)this.namesystem.getState())) {
            throw new StandbyException("Observer Node received request without stateId. This mostly likely is because client is not configured with " + ObserverReadProxyProvider.class.getSimpleName());
        }
        long serverStateId = this.getLastSeenStateId();
        long clientStateId = header.getStateId();
        if (FSNamesystem.LOG.isTraceEnabled()) {
            FSNamesystem.LOG.trace((Object)("Client State ID= " + clientStateId + " and Server State ID= " + serverStateId));
        }
        if (clientStateId > serverStateId && HAServiceProtocol.HAServiceState.ACTIVE.equals((Object)this.namesystem.getState())) {
            FSNamesystem.LOG.warn((Object)("The client stateId: " + clientStateId + " is greater than the server stateId: " + serverStateId + " This is unexpected. " + "Resetting client stateId to server stateId"));
            return serverStateId;
        }
        if (HAServiceProtocol.HAServiceState.OBSERVER.equals((Object)this.namesystem.getState()) && (float)(clientStateId - serverStateId) > (float)(10000L * TimeUnit.MILLISECONDS.toSeconds(clientWaitTime)) * 0.8f) {
            throw new RetriableException("Observer Node is too far behind: serverStateId = " + serverStateId + " clientStateId = " + clientStateId);
        }
        return clientStateId;
    }

    @Override
    public long getLastSeenStateId() {
        return this.namesystem.getFSImage().getLastAppliedOrWrittenTxId();
    }

    @Override
    public boolean isCoordinatedCall(String protocolName, String methodName) {
        return protocolName.equals(ClientProtocol.class.getCanonicalName()) && this.coordinatedMethods.contains(methodName);
    }
}

