/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.namenode;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.hdfs.protocol.LayoutVersion;

@InterfaceAudience.Private
public class NameNodeLayoutVersion {
    public static final Map<Integer, SortedSet<LayoutVersion.LayoutFeature>> FEATURES = new HashMap<Integer, SortedSet<LayoutVersion.LayoutFeature>>();
    public static final int CURRENT_LAYOUT_VERSION = LayoutVersion.getCurrentLayoutVersion(Feature.values());
    public static final int MINIMUM_COMPATIBLE_LAYOUT_VERSION = LayoutVersion.getMinimumCompatibleLayoutVersion(Feature.values());

    public static SortedSet<LayoutVersion.LayoutFeature> getFeatures(int lv) {
        return FEATURES.get(lv);
    }

    public static boolean supports(LayoutVersion.LayoutFeature f, int lv) {
        return LayoutVersion.supports(FEATURES, f, lv);
    }

    static {
        LayoutVersion.updateMap(FEATURES, LayoutVersion.Feature.values());
        LayoutVersion.updateMap(FEATURES, Feature.values());
    }

    public static enum Feature implements LayoutVersion.LayoutFeature
    {
        ROLLING_UPGRADE(-55, -53, -55, "Support rolling upgrade", false, new Feature[0]),
        EDITLOG_LENGTH(-56, -56, "Add length field to every edit log op"),
        XATTRS(-57, -57, "Extended attributes"),
        CREATE_OVERWRITE(-58, -58, "Use single editlog record for creating file with overwrite"),
        XATTRS_NAMESPACE_EXT(-59, -59, "Increase number of xattr namespaces"),
        BLOCK_STORAGE_POLICY(-60, -60, "Block Storage policy"),
        TRUNCATE(-61, -61, "Truncate"),
        APPEND_NEW_BLOCK(-62, -61, "Support appending to new block"),
        QUOTA_BY_STORAGE_TYPE(-63, -61, "Support quota for specific storage types");

        private final LayoutVersion.FeatureInfo info;

        private Feature(int lv, int minCompatLV, String description) {
            this(lv, lv + 1, minCompatLV, description, false, new Feature[0]);
        }

        private Feature(int lv, int ancestorLV, int minCompatLV, String description, boolean reserved, Feature ... features) {
            this.info = new LayoutVersion.FeatureInfo(lv, ancestorLV, minCompatLV, description, reserved, (LayoutVersion.LayoutFeature[])features);
        }

        @Override
        public LayoutVersion.FeatureInfo getInfo() {
            return this.info;
        }
    }
}

