/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.namenode;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.hdfs.server.namenode.AclEntryStatusFormat;
import shaded.org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import shaded.org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import shaded.org.apache.hadoop.hdfs.server.namenode.SerialNumberMap;
import shaded.org.apache.hadoop.hdfs.server.namenode.XAttrFormat;
import shaded.org.apache.hadoop.hdfs.util.LongBitFormat;

public enum SerialNumberManager {
    GLOBAL(new LongBitFormat.Enum[0]),
    USER(INodeWithAdditionalFields.PermissionStatusFormat.USER, AclEntryStatusFormat.NAME),
    GROUP(INodeWithAdditionalFields.PermissionStatusFormat.GROUP, AclEntryStatusFormat.NAME),
    XATTR(XAttrFormat.NAME);

    private static final SerialNumberManager[] values;
    private static final int maxEntryBits;
    private static final int maxEntryNumber;
    private static final int maskBits;
    private static boolean initialized;
    private SerialNumberMap<String> serialMap;
    private int bitLength = 32;
    private boolean enabled;

    static synchronized void initialize(Configuration conf) {
        boolean useExpanded = conf.getBoolean("dfs.image.string-tables.expanded", false);
        if (initialized) {
            if (useExpanded ^ !SerialNumberManager.GLOBAL.enabled) {
                throw new IllegalStateException("Cannot change serial maps");
            }
            return;
        }
        SerialNumberManager.initializeSerialMaps(useExpanded);
        for (SerialNumberManager snm : values) {
            if (!snm.enabled) continue;
            FSDirectory.LOG.info((Object)((Object)snm) + " serial map: bits=" + snm.getLength() + " maxEntries=" + snm.serialMap.getMax());
        }
        initialized = true;
    }

    private static void initializeSerialMaps(boolean useExpanded) {
        if (useExpanded) {
            for (SerialNumberManager snm : values) {
                snm.enabled = snm != GLOBAL;
                snm.serialMap = snm.enabled ? new SerialNumberMap(snm) : null;
            }
        } else {
            SerialNumberMap globalSerialMap = new SerialNumberMap(GLOBAL);
            for (SerialNumberManager snm : values) {
                snm.enabled = snm == GLOBAL;
                snm.serialMap = globalSerialMap;
            }
        }
    }

    private SerialNumberManager(LongBitFormat.Enum ... elements) {
        for (LongBitFormat.Enum element : elements) {
            this.updateLength(element.getLength());
        }
    }

    int getLength() {
        return this.bitLength;
    }

    private void updateLength(int maxLength) {
        this.bitLength = Math.min(this.bitLength, maxLength);
    }

    public int getSerialNumber(String u) {
        return this.serialMap.get(u);
    }

    public String getString(int id) {
        return this.serialMap.get(id);
    }

    public String getString(int id, StringTable stringTable) {
        return stringTable != null ? stringTable.get(this, id) : this.getString(id);
    }

    private int getMask(int bits) {
        return this.ordinal() << 32 - bits;
    }

    private static int getMaskBits() {
        return SerialNumberManager.GLOBAL.enabled ? 0 : maskBits;
    }

    private int size() {
        return this.enabled ? this.serialMap.size() : 0;
    }

    private Iterable<Map.Entry<Integer, String>> entrySet() {
        if (!this.enabled) {
            return Collections.emptySet();
        }
        return this.serialMap.entrySet();
    }

    public static StringTable getStringTable() {
        int size = 0;
        for (SerialNumberManager snm : values) {
            size += snm.size();
        }
        int tableMaskBits = SerialNumberManager.getMaskBits();
        StringTable map = new StringTable(size, tableMaskBits);
        for (SerialNumberManager snm : values) {
            int mask = snm.getMask(tableMaskBits);
            for (Map.Entry<Integer, String> entry : snm.entrySet()) {
                map.put(entry.getKey() | mask, entry.getValue());
            }
        }
        return map;
    }

    public static StringTable newStringTable(int size, int bits) {
        if (bits > maskBits) {
            throw new IllegalArgumentException("String table bits " + bits + " > " + maskBits);
        }
        return new StringTable(size, bits);
    }

    static {
        values = SerialNumberManager.values();
        maxEntryBits = Integer.numberOfLeadingZeros(values.length);
        maxEntryNumber = (1 << maxEntryBits) - 1;
        maskBits = 32 - maxEntryBits;
        for (SerialNumberManager snm : values) {
            snm.updateLength(maxEntryBits);
            GLOBAL.updateLength(snm.getLength());
        }
        SerialNumberManager.initializeSerialMaps(false);
    }

    public static class StringTable
    implements Iterable<Map.Entry<Integer, String>> {
        private final int tableMaskBits;
        private final Map<Integer, String> map;

        private StringTable(int size, int loadingMaskBits) {
            this.tableMaskBits = loadingMaskBits;
            this.map = new HashMap<Integer, String>(size);
        }

        private String get(SerialNumberManager snm, int id) {
            if (this.tableMaskBits != 0) {
                if (id > maxEntryNumber) {
                    throw new IllegalStateException("serial id " + id + " > " + maxEntryNumber);
                }
                id |= snm.getMask(this.tableMaskBits);
            }
            return this.map.get(id);
        }

        public void put(int id, String str) {
            this.map.put(id, str);
        }

        @Override
        public Iterator<Map.Entry<Integer, String>> iterator() {
            return this.map.entrySet().iterator();
        }

        public int size() {
            return this.map.size();
        }

        public int getMaskBits() {
            return this.tableMaskBits;
        }
    }
}

