/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.protocol;

import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.fs.StorageType;
import shaded.org.apache.hadoop.hdfs.protocol.Block;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlocksWithLocations {
    private final BlockWithLocations[] blocks;

    public BlocksWithLocations(BlockWithLocations[] blocks) {
        this.blocks = blocks;
    }

    public BlockWithLocations[] getBlocks() {
        return this.blocks;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static class BlockWithLocations {
        final Block block;
        final String[] datanodeUuids;
        final String[] storageIDs;
        final StorageType[] storageTypes;

        public BlockWithLocations(Block block, String[] datanodeUuids, String[] storageIDs, StorageType[] storageTypes) {
            this.block = block;
            this.datanodeUuids = datanodeUuids;
            this.storageIDs = storageIDs;
            this.storageTypes = storageTypes;
        }

        public Block getBlock() {
            return this.block;
        }

        public String[] getDatanodeUuids() {
            return this.datanodeUuids;
        }

        public String[] getStorageIDs() {
            return this.storageIDs;
        }

        public StorageType[] getStorageTypes() {
            return this.storageTypes;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.block);
            if (this.datanodeUuids.length == 0) {
                return b.append("[]").toString();
            }
            this.appendString(0, b.append("["));
            for (int i = 1; i < this.datanodeUuids.length; ++i) {
                this.appendString(i, b.append(","));
            }
            return b.append("]").toString();
        }

        private StringBuilder appendString(int i, StringBuilder b) {
            return b.append("[").append((Object)this.storageTypes[i]).append("]").append(this.storageIDs[i]).append("@").append(this.datanodeUuids[i]);
        }
    }
}

