/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import shaded.org.apache.hadoop.hdfs.util.LightWeightHashSet;

public class LightWeightLinkedSet<T>
extends LightWeightHashSet<T> {
    private DoubleLinkedElement<T> head = null;
    private DoubleLinkedElement<T> tail = null;
    private LinkedSetIterator bookmark = new LinkedSetIterator();

    public LightWeightLinkedSet(int initCapacity, float maxLoadFactor, float minLoadFactor) {
        super(initCapacity, maxLoadFactor, minLoadFactor);
    }

    public LightWeightLinkedSet() {
        this(16, 0.75f, 0.2f);
    }

    @Override
    protected boolean addElem(T element) {
        if (element == null) {
            throw new IllegalArgumentException("Null element is not supported.");
        }
        int hashCode = element.hashCode();
        int index = this.getIndex(hashCode);
        if (this.getContainedElem(index, element, hashCode) != null) {
            return false;
        }
        ++this.modification;
        ++this.size;
        DoubleLinkedElement<T> le = new DoubleLinkedElement<T>(element, hashCode);
        le.next = this.entries[index];
        this.entries[index] = le;
        ((DoubleLinkedElement)le).after = null;
        ((DoubleLinkedElement)le).before = (DoubleLinkedElement)this.tail;
        if (this.tail != null) {
            ((DoubleLinkedElement)this.tail).after = (DoubleLinkedElement)le;
        }
        this.tail = le;
        if (this.head == null) {
            this.head = le;
            this.bookmark.next = this.head;
        }
        if (this.bookmark.next == null) {
            this.bookmark.next = le;
        }
        return true;
    }

    @Override
    protected DoubleLinkedElement<T> removeElem(T key) {
        DoubleLinkedElement found = (DoubleLinkedElement)super.removeElem(key);
        if (found == null) {
            return null;
        }
        if (found.after != null) {
            found.after.before = found.before;
        }
        if (found.before != null) {
            found.before.after = found.after;
        }
        if (this.head == found) {
            this.head = ((DoubleLinkedElement)this.head).after;
        }
        if (this.tail == found) {
            this.tail = ((DoubleLinkedElement)this.tail).before;
        }
        if (found == this.bookmark.next) {
            this.bookmark.next = found.after;
        }
        return found;
    }

    public T pollFirst() {
        if (this.head == null) {
            return null;
        }
        Object first = this.head.element;
        this.remove(first);
        return (T)first;
    }

    @Override
    public List<T> pollN(int n) {
        if (n >= this.size) {
            return this.pollAll();
        }
        ArrayList<Object> retList = new ArrayList<Object>(n);
        while (n-- > 0 && this.head != null) {
            Object curr = this.head.element;
            this.removeElem(curr);
            retList.add(curr);
        }
        this.shrinkIfNecessary();
        return retList;
    }

    @Override
    public List<T> pollAll() {
        ArrayList<Object> retList = new ArrayList<Object>(this.size);
        while (this.head != null) {
            retList.add(this.head.element);
            this.head = ((DoubleLinkedElement)this.head).after;
        }
        this.clear();
        return retList;
    }

    @Override
    public <U> U[] toArray(U[] a) {
        if (a == null) {
            throw new NullPointerException("Input array can not be null");
        }
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        int currentIndex = 0;
        DoubleLinkedElement current = this.head;
        while (current != null) {
            Object curr = current.element;
            a[currentIndex++] = curr;
            current = current.after;
        }
        return a;
    }

    @Override
    public Iterator<T> iterator() {
        return new LinkedSetIterator();
    }

    @Override
    public void clear() {
        super.clear();
        this.head = null;
        this.tail = null;
        this.resetBookmark();
    }

    public Iterator<T> getBookmark() {
        LinkedSetIterator toRet = new LinkedSetIterator();
        toRet.next = this.bookmark.next;
        this.bookmark = toRet;
        return toRet;
    }

    public void resetBookmark() {
        this.bookmark.next = this.head;
    }

    private class LinkedSetIterator
    implements Iterator<T> {
        private final int startModification;
        private DoubleLinkedElement<T> next;

        private LinkedSetIterator() {
            this.startModification = LightWeightLinkedSet.this.modification;
            this.next = LightWeightLinkedSet.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (LightWeightLinkedSet.this.modification != this.startModification) {
                throw new ConcurrentModificationException("modification=" + LightWeightLinkedSet.this.modification + " != startModification = " + this.startModification);
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object e = this.next.element;
            this.next = this.next.after;
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }
    }

    static class DoubleLinkedElement<T>
    extends LightWeightHashSet.LinkedElement<T> {
        private DoubleLinkedElement<T> before = null;
        private DoubleLinkedElement<T> after = null;

        public DoubleLinkedElement(T elem, int hashCode) {
            super(elem, hashCode);
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }
}

