/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.web;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import shaded.org.apache.hadoop.util.StringUtils;

public class ParamFilter
implements ResourceFilter {
    private static final ContainerRequestFilter LOWER_CASE = new ContainerRequestFilter(){

        public ContainerRequest filter(ContainerRequest request) {
            MultivaluedMap parameters = request.getQueryParameters();
            if (ParamFilter.containsUpperCase(parameters.keySet())) {
                URI lower = ParamFilter.rebuildQuery(request.getRequestUri(), (MultivaluedMap<String, String>)parameters);
                request.setUris(request.getBaseUri(), lower);
            }
            return request;
        }
    };

    public ContainerRequestFilter getRequestFilter() {
        return LOWER_CASE;
    }

    public ContainerResponseFilter getResponseFilter() {
        return null;
    }

    static boolean containsUpperCase(Iterable<String> strings) {
        for (String s : strings) {
            for (int i = 0; i < s.length(); ++i) {
                if (!Character.isUpperCase(s.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    private static URI rebuildQuery(URI uri, MultivaluedMap<String, String> parameters) {
        UriBuilder b = UriBuilder.fromUri((URI)uri).replaceQuery("");
        for (Map.Entry e : parameters.entrySet()) {
            String key = StringUtils.toLowerCase((String)e.getKey());
            for (String v : (List)e.getValue()) {
                b = b.queryParam(key, new Object[]{v});
            }
        }
        return b.build(new Object[0]);
    }
}

