/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import shaded.org.apache.hadoop.conf.Configurable;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.io.compress.CompressionCodec;
import shaded.org.apache.hadoop.io.compress.CompressionInputStream;
import shaded.org.apache.hadoop.io.compress.CompressionOutputStream;
import shaded.org.apache.hadoop.io.compress.Compressor;
import shaded.org.apache.hadoop.io.compress.CompressorStream;
import shaded.org.apache.hadoop.io.compress.Decompressor;
import shaded.org.apache.hadoop.io.compress.DecompressorStream;
import shaded.org.apache.hadoop.io.compress.DirectDecompressionCodec;
import shaded.org.apache.hadoop.io.compress.DirectDecompressor;
import shaded.org.apache.hadoop.io.compress.zstd.ZStandardCompressor;
import shaded.org.apache.hadoop.io.compress.zstd.ZStandardDecompressor;
import shaded.org.apache.hadoop.util.NativeCodeLoader;

public class ZStandardCodec
implements Configurable,
CompressionCodec,
DirectDecompressionCodec {
    private Configuration conf;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    public static void checkNativeCodeLoaded() {
        if (!NativeCodeLoader.isNativeCodeLoaded() || !NativeCodeLoader.buildSupportsZstd()) {
            throw new RuntimeException("native zStandard library not available: this version of libhadoop was built without zstd support.");
        }
        if (!ZStandardCompressor.isNativeCodeLoaded()) {
            throw new RuntimeException("native zStandard library not available: ZStandardCompressor has not been loaded.");
        }
        if (!ZStandardDecompressor.isNativeCodeLoaded()) {
            throw new RuntimeException("native zStandard library not available: ZStandardDecompressor has not been loaded.");
        }
    }

    public static boolean isNativeCodeLoaded() {
        return ZStandardCompressor.isNativeCodeLoaded() && ZStandardDecompressor.isNativeCodeLoaded();
    }

    public static String getLibraryName() {
        return ZStandardCompressor.getLibraryName();
    }

    public static int getCompressionLevel(Configuration conf) {
        return conf.getInt("io.compression.codec.zstd.level", 3);
    }

    public static int getCompressionBufferSize(Configuration conf) {
        int bufferSize = ZStandardCodec.getBufferSize(conf);
        return bufferSize == 0 ? ZStandardCompressor.getRecommendedBufferSize() : bufferSize;
    }

    public static int getDecompressionBufferSize(Configuration conf) {
        int bufferSize = ZStandardCodec.getBufferSize(conf);
        return bufferSize == 0 ? ZStandardDecompressor.getRecommendedBufferSize() : bufferSize;
    }

    private static int getBufferSize(Configuration conf) {
        return conf.getInt("io.compression.codec.zstd.buffersize", 0);
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return CompressionCodec.Util.createOutputStreamWithCodecPool(this, this.conf, out);
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        ZStandardCodec.checkNativeCodeLoaded();
        return new CompressorStream(out, compressor, ZStandardCodec.getCompressionBufferSize(this.conf));
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        ZStandardCodec.checkNativeCodeLoaded();
        return ZStandardCompressor.class;
    }

    @Override
    public Compressor createCompressor() {
        ZStandardCodec.checkNativeCodeLoaded();
        return new ZStandardCompressor(ZStandardCodec.getCompressionLevel(this.conf), ZStandardCodec.getCompressionBufferSize(this.conf));
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return CompressionCodec.Util.createInputStreamWithCodecPool(this, this.conf, in);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        ZStandardCodec.checkNativeCodeLoaded();
        return new DecompressorStream(in, decompressor, ZStandardCodec.getDecompressionBufferSize(this.conf));
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        ZStandardCodec.checkNativeCodeLoaded();
        return ZStandardDecompressor.class;
    }

    @Override
    public Decompressor createDecompressor() {
        ZStandardCodec.checkNativeCodeLoaded();
        return new ZStandardDecompressor(ZStandardCodec.getDecompressionBufferSize(this.conf));
    }

    @Override
    public String getDefaultExtension() {
        return ".zst";
    }

    @Override
    public DirectDecompressor createDirectDecompressor() {
        return new ZStandardDecompressor.ZStandardDirectDecompressor(ZStandardCodec.getDecompressionBufferSize(this.conf));
    }
}

