/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.io.compress.zstd;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.io.compress.Compressor;
import shaded.org.apache.hadoop.io.compress.ZStandardCodec;
import shaded.org.apache.hadoop.util.NativeCodeLoader;

public class ZStandardCompressor
implements Compressor {
    private static final Logger LOG = LoggerFactory.getLogger(ZStandardCompressor.class);
    private long stream;
    private int level;
    private int directBufferSize;
    private byte[] userBuf = null;
    private int userBufOff = 0;
    private int userBufLen = 0;
    private ByteBuffer uncompressedDirectBuf = null;
    private int uncompressedDirectBufOff = 0;
    private int uncompressedDirectBufLen = 0;
    private boolean keepUncompressedBuf = false;
    private ByteBuffer compressedDirectBuf = null;
    private boolean finish;
    private boolean finished;
    private long bytesRead = 0L;
    private long bytesWritten = 0L;
    private static boolean nativeZStandardLoaded = false;

    public static boolean isNativeCodeLoaded() {
        return nativeZStandardLoaded;
    }

    public static int getRecommendedBufferSize() {
        return ZStandardCompressor.getStreamSize();
    }

    @VisibleForTesting
    ZStandardCompressor() {
        this(3, 4096);
    }

    public ZStandardCompressor(int level, int bufferSize) {
        this(level, bufferSize, bufferSize);
    }

    @VisibleForTesting
    ZStandardCompressor(int level, int inputBufferSize, int outputBufferSize) {
        this.level = level;
        this.stream = ZStandardCompressor.create();
        this.directBufferSize = outputBufferSize;
        this.uncompressedDirectBuf = ByteBuffer.allocateDirect(inputBufferSize);
        this.compressedDirectBuf = ByteBuffer.allocateDirect(outputBufferSize);
        this.compressedDirectBuf.position(outputBufferSize);
        this.reset();
    }

    @Override
    public void reinit(Configuration conf) {
        if (conf == null) {
            return;
        }
        this.level = ZStandardCodec.getCompressionLevel(conf);
        this.reset();
        LOG.debug("Reinit compressor with new compression configuration");
    }

    @Override
    public void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.userBuf = b;
        this.userBufOff = off;
        this.userBufLen = len;
        this.uncompressedDirectBufOff = 0;
        this.setInputFromSavedData();
        this.compressedDirectBuf.limit(this.directBufferSize);
        this.compressedDirectBuf.position(this.directBufferSize);
    }

    private void setInputFromSavedData() {
        int len = Math.min(this.userBufLen, this.uncompressedDirectBuf.remaining());
        this.uncompressedDirectBuf.put(this.userBuf, this.userBufOff, len);
        this.userBufLen -= len;
        this.userBufOff += len;
        this.uncompressedDirectBufLen = this.uncompressedDirectBuf.position();
    }

    @Override
    public void setDictionary(byte[] b, int off, int len) {
        throw new UnsupportedOperationException("Dictionary support is not enabled");
    }

    @Override
    public boolean needsInput() {
        if (this.compressedDirectBuf.remaining() > 0) {
            return false;
        }
        if (this.keepUncompressedBuf && this.uncompressedDirectBufLen > 0) {
            return false;
        }
        if (this.uncompressedDirectBuf.remaining() > 0) {
            if (this.userBufLen <= 0) {
                return true;
            }
            this.setInputFromSavedData();
            return this.uncompressedDirectBuf.remaining() > 0;
        }
        return false;
    }

    @Override
    public void finish() {
        this.finish = true;
    }

    @Override
    public boolean finished() {
        return this.finished && this.compressedDirectBuf.remaining() == 0;
    }

    @Override
    public int compress(byte[] b, int off, int len) throws IOException {
        this.checkStream();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = this.compressedDirectBuf.remaining();
        if (n > 0) {
            n = Math.min(n, len);
            this.compressedDirectBuf.get(b, off, n);
            return n;
        }
        this.compressedDirectBuf.rewind();
        this.compressedDirectBuf.limit(this.directBufferSize);
        n = this.deflateBytesDirect(this.uncompressedDirectBuf, this.uncompressedDirectBufOff, this.uncompressedDirectBufLen, this.compressedDirectBuf, this.directBufferSize);
        this.compressedDirectBuf.limit(n);
        if (this.uncompressedDirectBufLen <= 0) {
            this.keepUncompressedBuf = false;
            this.uncompressedDirectBuf.clear();
            this.uncompressedDirectBufOff = 0;
            this.uncompressedDirectBufLen = 0;
        } else {
            this.keepUncompressedBuf = true;
        }
        n = Math.min(n, len);
        this.compressedDirectBuf.get(b, off, n);
        return n;
    }

    @Override
    public long getBytesWritten() {
        this.checkStream();
        return this.bytesWritten;
    }

    @Override
    public long getBytesRead() {
        this.checkStream();
        return this.bytesRead;
    }

    @Override
    public void reset() {
        this.checkStream();
        ZStandardCompressor.init(this.level, this.stream);
        this.finish = false;
        this.finished = false;
        this.bytesRead = 0L;
        this.bytesWritten = 0L;
        this.uncompressedDirectBuf.rewind();
        this.uncompressedDirectBufOff = 0;
        this.uncompressedDirectBufLen = 0;
        this.keepUncompressedBuf = false;
        this.compressedDirectBuf.limit(this.directBufferSize);
        this.compressedDirectBuf.position(this.directBufferSize);
        this.userBufOff = 0;
        this.userBufLen = 0;
    }

    @Override
    public void end() {
        if (this.stream != 0L) {
            ZStandardCompressor.end(this.stream);
            this.stream = 0L;
        }
    }

    private void checkStream() {
        if (this.stream == 0L) {
            throw new NullPointerException();
        }
    }

    private static native long create();

    private static native void init(int var0, long var1);

    private native int deflateBytesDirect(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5);

    private static native int getStreamSize();

    private static native void end(long var0);

    private static native void initIDs();

    public static native String getLibraryName();

    static {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            try {
                ZStandardCompressor.initIDs();
                nativeZStandardLoaded = true;
            }
            catch (Throwable t) {
                LOG.warn("Error loading zstandard native libraries: " + t);
            }
        }
    }
}

