/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.ipc;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.UUID;
import shaded.org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ClientId {
    public static final int BYTE_LENGTH = 16;
    private static final int shiftWidth = 8;

    public static byte[] getClientId() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer buf = ByteBuffer.wrap(new byte[16]);
        buf.putLong(uuid.getMostSignificantBits());
        buf.putLong(uuid.getLeastSignificantBits());
        return buf.array();
    }

    public static String toString(byte[] clientId) {
        if (clientId == null || clientId.length == 0) {
            return "";
        }
        Preconditions.checkArgument((clientId.length == 16 ? 1 : 0) != 0);
        long msb = ClientId.getMsb(clientId);
        long lsb = ClientId.getLsb(clientId);
        return new UUID(msb, lsb).toString();
    }

    public static long getMsb(byte[] clientId) {
        long msb = 0L;
        for (int i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(clientId[i] & 0xFF);
        }
        return msb;
    }

    public static long getLsb(byte[] clientId) {
        long lsb = 0L;
        for (int i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(clientId[i] & 0xFF);
        }
        return lsb;
    }

    public static byte[] toBytes(String id) {
        if (id == null || "".equals(id)) {
            return new byte[0];
        }
        UUID uuid = UUID.fromString(id);
        ByteBuffer buf = ByteBuffer.wrap(new byte[16]);
        buf.putLong(uuid.getMostSignificantBits());
        buf.putLong(uuid.getLeastSignificantBits());
        return buf.array();
    }
}

