/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred;

import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.net.NetUtils;
import shaded.org.apache.hadoop.security.SecurityUtil;
import shaded.org.apache.hadoop.yarn.client.util.YarnClientUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class Master {
    public static String getMasterAddress(Configuration conf) {
        String masterAddress = conf.get("mapreduce.jobtracker.address", "localhost:8012");
        return NetUtils.createSocketAddr(masterAddress, 8012, "mapreduce.jobtracker.address").getHostName();
    }

    public static String getMasterPrincipal(Configuration conf) throws IOException {
        String masterPrincipal;
        String framework = conf.get("mapreduce.framework.name", "yarn");
        if (framework.equals("classic")) {
            String masterAddress = Master.getMasterAddress(conf);
            masterPrincipal = SecurityUtil.getServerPrincipal(conf.get("mapreduce.jobtracker.kerberos.principal"), masterAddress);
        } else {
            masterPrincipal = YarnClientUtils.getRmPrincipal((Configuration)conf);
        }
        return masterPrincipal;
    }

    public static enum State {
        INITIALIZING,
        RUNNING;

    }
}

