/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import shaded.org.apache.hadoop.mapred.Counters;
import shaded.org.apache.hadoop.mapred.TaskAttemptID;
import shaded.org.apache.hadoop.mapred.TaskStatus;

class ReduceTaskStatus
extends TaskStatus {
    private long shuffleFinishTime;
    private long sortFinishTime;
    private List<TaskAttemptID> failedFetchTasks = new ArrayList<TaskAttemptID>(1);

    public ReduceTaskStatus() {
    }

    public ReduceTaskStatus(TaskAttemptID taskid, float progress, int numSlots, TaskStatus.State runState, String diagnosticInfo, String stateString, String taskTracker, TaskStatus.Phase phase, Counters counters) {
        super(taskid, progress, numSlots, runState, diagnosticInfo, stateString, taskTracker, phase, counters);
    }

    @Override
    public Object clone() {
        ReduceTaskStatus myClone = (ReduceTaskStatus)super.clone();
        myClone.failedFetchTasks = new ArrayList<TaskAttemptID>(this.failedFetchTasks);
        return myClone;
    }

    @Override
    public boolean getIsMap() {
        return false;
    }

    @Override
    void setFinishTime(long finishTime) {
        if (this.shuffleFinishTime == 0L) {
            this.shuffleFinishTime = finishTime;
        }
        if (this.sortFinishTime == 0L) {
            this.sortFinishTime = finishTime;
        }
        super.setFinishTime(finishTime);
    }

    @Override
    public long getShuffleFinishTime() {
        return this.shuffleFinishTime;
    }

    @Override
    void setShuffleFinishTime(long shuffleFinishTime) {
        this.shuffleFinishTime = shuffleFinishTime;
    }

    @Override
    public long getSortFinishTime() {
        return this.sortFinishTime;
    }

    @Override
    void setSortFinishTime(long sortFinishTime) {
        this.sortFinishTime = sortFinishTime;
        if (0L == this.shuffleFinishTime) {
            this.shuffleFinishTime = sortFinishTime;
        }
    }

    @Override
    public long getMapFinishTime() {
        throw new UnsupportedOperationException("getMapFinishTime() not supported for ReduceTask");
    }

    @Override
    void setMapFinishTime(long shuffleFinishTime) {
        throw new UnsupportedOperationException("setMapFinishTime() not supported for ReduceTask");
    }

    @Override
    public List<TaskAttemptID> getFetchFailedMaps() {
        return this.failedFetchTasks;
    }

    @Override
    public void addFetchFailedMap(TaskAttemptID mapTaskId) {
        this.failedFetchTasks.add(mapTaskId);
    }

    @Override
    synchronized void statusUpdate(TaskStatus status) {
        super.statusUpdate(status);
        if (status.getShuffleFinishTime() != 0L) {
            this.shuffleFinishTime = status.getShuffleFinishTime();
        }
        if (status.getSortFinishTime() != 0L) {
            this.sortFinishTime = status.getSortFinishTime();
        }
        List<TaskAttemptID> newFetchFailedMaps = status.getFetchFailedMaps();
        if (this.failedFetchTasks == null) {
            this.failedFetchTasks = newFetchFailedMaps;
        } else if (newFetchFailedMaps != null) {
            this.failedFetchTasks.addAll(newFetchFailedMaps);
        }
    }

    @Override
    synchronized void clearStatus() {
        super.clearStatus();
        this.failedFetchTasks.clear();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.shuffleFinishTime = in.readLong();
        this.sortFinishTime = in.readLong();
        int noFailedFetchTasks = in.readInt();
        this.failedFetchTasks = new ArrayList<TaskAttemptID>(noFailedFetchTasks);
        for (int i = 0; i < noFailedFetchTasks; ++i) {
            TaskAttemptID id = new TaskAttemptID();
            id.readFields(in);
            this.failedFetchTasks.add(id);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.shuffleFinishTime);
        out.writeLong(this.sortFinishTime);
        out.writeInt(this.failedFetchTasks.size());
        for (TaskAttemptID taskId : this.failedFetchTasks) {
            taskId.write(out);
        }
    }
}

