/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred;

import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.fs.FileStatus;
import shaded.org.apache.hadoop.fs.FileSystem;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.mapred.FileInputFormat;
import shaded.org.apache.hadoop.mapred.FileSplit;
import shaded.org.apache.hadoop.mapred.InputSplit;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapred.RecordReader;
import shaded.org.apache.hadoop.mapred.Reporter;
import shaded.org.apache.hadoop.mapred.SequenceFileRecordReader;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SequenceFileInputFormat<K, V>
extends FileInputFormat<K, V> {
    public SequenceFileInputFormat() {
        this.setMinSplitSize(2000L);
    }

    @Override
    protected FileStatus[] listStatus(JobConf job) throws IOException {
        FileStatus[] files = super.listStatus(job);
        for (int i = 0; i < files.length; ++i) {
            FileStatus file = files[i];
            if (!file.isDirectory()) continue;
            Path dataFile = new Path(file.getPath(), "data");
            FileSystem fs = file.getPath().getFileSystem(job);
            files[i] = fs.getFileStatus(dataFile);
        }
        return files;
    }

    @Override
    public RecordReader<K, V> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(split.toString());
        return new SequenceFileRecordReader(job, (FileSplit)split);
    }
}

