/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred.jobcontrol;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.mapred.JobClient;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapred.JobID;
import shaded.org.apache.hadoop.mapred.jobcontrol.JobControl;
import shaded.org.apache.hadoop.mapreduce.lib.jobcontrol.ControlledJob;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Job
extends ControlledJob {
    static final Log LOG = LogFactory.getLog(Job.class);
    public static final int SUCCESS = 0;
    public static final int WAITING = 1;
    public static final int RUNNING = 2;
    public static final int READY = 3;
    public static final int FAILED = 4;
    public static final int DEPENDENT_FAILED = 5;

    public Job(JobConf jobConf, ArrayList<?> dependingJobs) throws IOException {
        super(shaded.org.apache.hadoop.mapreduce.Job.getInstance(jobConf), dependingJobs);
    }

    public Job(JobConf conf) throws IOException {
        super(conf);
    }

    public JobID getAssignedJobID() {
        shaded.org.apache.hadoop.mapreduce.JobID temp = super.getMapredJobId();
        if (temp == null) {
            return null;
        }
        return JobID.downgrade(temp);
    }

    @Deprecated
    public void setAssignedJobID(JobID mapredJobID) {
    }

    public synchronized JobConf getJobConf() {
        return new JobConf(super.getJob().getConfiguration());
    }

    public synchronized void setJobConf(JobConf jobConf) {
        try {
            super.setJob(shaded.org.apache.hadoop.mapreduce.Job.getInstance(jobConf));
        }
        catch (IOException ioe) {
            LOG.info((Object)("Exception" + ioe));
        }
    }

    public synchronized int getState() {
        ControlledJob.State state = super.getJobState();
        if (state == ControlledJob.State.SUCCESS) {
            return 0;
        }
        if (state == ControlledJob.State.WAITING) {
            return 1;
        }
        if (state == ControlledJob.State.RUNNING) {
            return 2;
        }
        if (state == ControlledJob.State.READY) {
            return 3;
        }
        if (state == ControlledJob.State.FAILED) {
            return 4;
        }
        if (state == ControlledJob.State.DEPENDENT_FAILED) {
            return 5;
        }
        return -1;
    }

    @Deprecated
    protected synchronized void setState(int state) {
    }

    public synchronized boolean addDependingJob(Job dependingJob) {
        return super.addDependingJob(dependingJob);
    }

    public JobClient getJobClient() {
        try {
            return new JobClient(super.getJob().getConfiguration());
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public ArrayList<Job> getDependingJobs() {
        return JobControl.castToJobList(super.getDependentJobs());
    }

    public synchronized String getMapredJobID() {
        if (super.getMapredJobId() != null) {
            return super.getMapredJobId().toString();
        }
        return null;
    }

    @Deprecated
    public synchronized void setMapredJobID(String mapredJobID) {
        this.setAssignedJobID(JobID.forName(mapredJobID));
    }
}

