/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred.join;

import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configurable;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.io.Writable;
import shaded.org.apache.hadoop.io.WritableComparable;
import shaded.org.apache.hadoop.io.WritableComparator;
import shaded.org.apache.hadoop.io.WritableUtils;
import shaded.org.apache.hadoop.mapred.RecordReader;
import shaded.org.apache.hadoop.mapred.join.ComposableRecordReader;
import shaded.org.apache.hadoop.mapred.join.CompositeRecordReader;
import shaded.org.apache.hadoop.mapred.join.ResetableIterator;
import shaded.org.apache.hadoop.mapred.join.StreamBackedIterator;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class WrappedRecordReader<K extends WritableComparable, U extends Writable>
implements ComposableRecordReader<K, U>,
Configurable {
    private boolean empty = false;
    private RecordReader<K, U> rr;
    private int id;
    private K khead;
    private U vhead;
    private WritableComparator cmp;
    private Configuration conf;
    private ResetableIterator<U> vjoin;

    WrappedRecordReader(int id, RecordReader<K, U> rr, Class<? extends WritableComparator> cmpcl) throws IOException {
        this(id, rr, cmpcl, null);
    }

    WrappedRecordReader(int id, RecordReader<K, U> rr, Class<? extends WritableComparator> cmpcl, Configuration conf) throws IOException {
        this.id = id;
        this.rr = rr;
        this.conf = conf == null ? new Configuration() : conf;
        this.khead = (WritableComparable)rr.createKey();
        this.vhead = (Writable)rr.createValue();
        try {
            this.cmp = null == cmpcl ? WritableComparator.get(this.khead.getClass(), this.conf) : cmpcl.newInstance();
        }
        catch (InstantiationException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (IllegalAccessException e) {
            throw (IOException)new IOException().initCause(e);
        }
        this.vjoin = new StreamBackedIterator<U>();
        this.next();
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public K key() {
        return this.khead;
    }

    @Override
    public void key(K qkey) throws IOException {
        WritableUtils.cloneInto(qkey, this.khead);
    }

    @Override
    public boolean hasNext() {
        return !this.empty;
    }

    @Override
    public void skip(K key) throws IOException {
        if (this.hasNext()) {
            while (this.cmp.compare((WritableComparable)this.khead, (WritableComparable)key) <= 0 && this.next()) {
            }
        }
    }

    protected boolean next() throws IOException {
        this.empty = !this.rr.next(this.khead, this.vhead);
        return this.hasNext();
    }

    @Override
    public void accept(CompositeRecordReader.JoinCollector i, K key) throws IOException {
        this.vjoin.clear();
        if (0 == this.cmp.compare((WritableComparable)key, (WritableComparable)this.khead)) {
            do {
                this.vjoin.add(this.vhead);
            } while (this.next() && 0 == this.cmp.compare((WritableComparable)key, (WritableComparable)this.khead));
        }
        i.add(this.id, this.vjoin);
    }

    @Override
    public boolean next(K key, U value) throws IOException {
        if (this.hasNext()) {
            WritableUtils.cloneInto(key, this.khead);
            WritableUtils.cloneInto(value, this.vhead);
            this.next();
            return true;
        }
        return false;
    }

    @Override
    public K createKey() {
        return (K)((WritableComparable)this.rr.createKey());
    }

    @Override
    public U createValue() {
        return (U)((Writable)this.rr.createValue());
    }

    @Override
    public float getProgress() throws IOException {
        return this.rr.getProgress();
    }

    @Override
    public long getPos() throws IOException {
        return this.rr.getPos();
    }

    @Override
    public void close() throws IOException {
        this.rr.close();
    }

    @Override
    public int compareTo(ComposableRecordReader<K, ?> other) {
        return this.cmp.compare((WritableComparable)this.key(), (WritableComparable)other.key());
    }

    public boolean equals(Object other) {
        return other instanceof ComposableRecordReader && 0 == this.compareTo((ComposableRecordReader)other);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }
}

