/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.mapred.InputFormat;
import shaded.org.apache.hadoop.mapred.InputSplit;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapred.RecordReader;
import shaded.org.apache.hadoop.mapred.Reporter;
import shaded.org.apache.hadoop.mapreduce.Job;
import shaded.org.apache.hadoop.mapreduce.lib.partition.InputSampler;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class InputSampler<K, V>
extends shaded.org.apache.hadoop.mapreduce.lib.partition.InputSampler<K, V> {
    private static final Log LOG = LogFactory.getLog(InputSampler.class);

    public InputSampler(JobConf conf) {
        super(conf);
    }

    public static <K, V> void writePartitionFile(JobConf job, Sampler<K, V> sampler) throws IOException, ClassNotFoundException, InterruptedException {
        InputSampler.writePartitionFile(Job.getInstance(job), sampler);
    }

    public static class IntervalSampler<K, V>
    extends InputSampler.IntervalSampler<K, V>
    implements Sampler<K, V> {
        public IntervalSampler(double freq) {
            this(freq, Integer.MAX_VALUE);
        }

        public IntervalSampler(double freq, int maxSplitsSampled) {
            super(freq, maxSplitsSampled);
        }

        @Override
        public K[] getSample(InputFormat<K, V> inf, JobConf job) throws IOException {
            InputSplit[] splits = inf.getSplits(job, job.getNumMapTasks());
            ArrayList<K> samples = new ArrayList<K>();
            int splitsToSample = Math.min(this.maxSplitsSampled, splits.length);
            int splitStep = splits.length / splitsToSample;
            long records = 0L;
            long kept = 0L;
            for (int i = 0; i < splitsToSample; ++i) {
                RecordReader<K, V> reader = inf.getRecordReader(splits[i * splitStep], job, Reporter.NULL);
                K key = reader.createKey();
                V value = reader.createValue();
                while (reader.next(key, value)) {
                    if (!((double)kept / (double)(++records) < this.freq)) continue;
                    ++kept;
                    samples.add(key);
                    key = reader.createKey();
                }
                reader.close();
            }
            return samples.toArray();
        }
    }

    public static class RandomSampler<K, V>
    extends InputSampler.RandomSampler<K, V>
    implements Sampler<K, V> {
        public RandomSampler(double freq, int numSamples) {
            this(freq, numSamples, Integer.MAX_VALUE);
        }

        public RandomSampler(double freq, int numSamples, int maxSplitsSampled) {
            super(freq, numSamples, maxSplitsSampled);
        }

        @Override
        public K[] getSample(InputFormat<K, V> inf, JobConf job) throws IOException {
            int i;
            InputSplit[] splits = inf.getSplits(job, job.getNumMapTasks());
            ArrayList<K> samples = new ArrayList<K>(this.numSamples);
            int splitsToSample = Math.min(this.maxSplitsSampled, splits.length);
            Random r = new Random();
            long seed = r.nextLong();
            r.setSeed(seed);
            LOG.debug((Object)("seed: " + seed));
            for (i = 0; i < splits.length; ++i) {
                InputSplit tmp = splits[i];
                int j = r.nextInt(splits.length);
                splits[i] = splits[j];
                splits[j] = tmp;
            }
            for (i = 0; i < splitsToSample || i < splits.length && samples.size() < this.numSamples; ++i) {
                RecordReader<K, V> reader = inf.getRecordReader(splits[i], job, Reporter.NULL);
                K key = reader.createKey();
                V value = reader.createValue();
                while (reader.next(key, value)) {
                    if (!(r.nextDouble() <= this.freq)) continue;
                    if (samples.size() < this.numSamples) {
                        samples.add(key);
                    } else {
                        int ind = r.nextInt(this.numSamples);
                        if (ind != this.numSamples) {
                            samples.set(ind, key);
                        }
                        this.freq *= (double)(this.numSamples - 1) / (double)this.numSamples;
                    }
                    key = reader.createKey();
                }
                reader.close();
            }
            return samples.toArray();
        }
    }

    public static class SplitSampler<K, V>
    extends InputSampler.SplitSampler<K, V>
    implements Sampler<K, V> {
        public SplitSampler(int numSamples) {
            this(numSamples, Integer.MAX_VALUE);
        }

        public SplitSampler(int numSamples, int maxSplitsSampled) {
            super(numSamples, maxSplitsSampled);
        }

        @Override
        public K[] getSample(InputFormat<K, V> inf, JobConf job) throws IOException {
            InputSplit[] splits = inf.getSplits(job, job.getNumMapTasks());
            ArrayList<K> samples = new ArrayList<K>(this.numSamples);
            int splitsToSample = Math.min(this.maxSplitsSampled, splits.length);
            int splitStep = splits.length / splitsToSample;
            int samplesPerSplit = this.numSamples / splitsToSample;
            long records = 0L;
            for (int i = 0; i < splitsToSample; ++i) {
                RecordReader<K, V> reader = inf.getRecordReader(splits[i * splitStep], job, Reporter.NULL);
                K key = reader.createKey();
                V value = reader.createValue();
                while (reader.next(key, value)) {
                    samples.add(key);
                    key = reader.createKey();
                    if ((long)((i + 1) * samplesPerSplit) > ++records) continue;
                }
                reader.close();
            }
            return samples.toArray();
        }
    }

    public static interface Sampler<K, V>
    extends InputSampler.Sampler<K, V> {
        public K[] getSample(InputFormat<K, V> var1, JobConf var2) throws IOException;
    }
}

