/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.crypto.CryptoCodec;
import shaded.org.apache.hadoop.crypto.CryptoInputStream;
import shaded.org.apache.hadoop.fs.FSDataInputStream;
import shaded.org.apache.hadoop.fs.FSDataOutputStream;
import shaded.org.apache.hadoop.fs.crypto.CryptoFSDataInputStream;
import shaded.org.apache.hadoop.fs.crypto.CryptoFSDataOutputStream;
import shaded.org.apache.hadoop.io.IOUtils;
import shaded.org.apache.hadoop.mapreduce.security.TokenCache;
import shaded.org.apache.hadoop.security.UserGroupInformation;
import shaded.org.apache.hadoop.util.LimitInputStream;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CryptoUtils {
    private static final Log LOG = LogFactory.getLog(CryptoUtils.class);

    public static boolean isEncryptedSpillEnabled(Configuration conf) {
        return conf.getBoolean("mapreduce.job.encrypted-intermediate-data", false);
    }

    public static byte[] createIV(Configuration conf) throws IOException {
        CryptoCodec cryptoCodec = CryptoCodec.getInstance(conf);
        if (CryptoUtils.isEncryptedSpillEnabled(conf)) {
            byte[] iv = new byte[cryptoCodec.getCipherSuite().getAlgorithmBlockSize()];
            cryptoCodec.generateSecureRandom(iv);
            cryptoCodec.close();
            return iv;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int cryptoPadding(Configuration conf) throws IOException {
        if (!CryptoUtils.isEncryptedSpillEnabled(conf)) {
            return 0;
        }
        try (CryptoCodec cryptoCodec = CryptoCodec.getInstance(conf);){
            int n = cryptoCodec.getCipherSuite().getAlgorithmBlockSize() + 8;
            return n;
        }
    }

    private static byte[] getEncryptionKey() throws IOException {
        return TokenCache.getEncryptedSpillKey(UserGroupInformation.getCurrentUser().getCredentials());
    }

    private static int getBufferSize(Configuration conf) {
        return conf.getInt("mapreduce.job.encrypted-intermediate-data.buffer.kb", 128) * 1024;
    }

    public static FSDataOutputStream wrapIfNecessary(Configuration conf, FSDataOutputStream out) throws IOException {
        return CryptoUtils.wrapIfNecessary(conf, out, true);
    }

    public static FSDataOutputStream wrapIfNecessary(Configuration conf, FSDataOutputStream out, boolean closeOutputStream) throws IOException {
        if (CryptoUtils.isEncryptedSpillEnabled(conf)) {
            out.write(ByteBuffer.allocate(8).putLong(out.getPos()).array());
            byte[] iv = CryptoUtils.createIV(conf);
            out.write(iv);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("IV written to Stream [" + Base64.encodeBase64URLSafeString((byte[])iv) + "]"));
            }
            return new CryptoFSDataOutputStream(out, CryptoCodec.getInstance(conf), CryptoUtils.getBufferSize(conf), CryptoUtils.getEncryptionKey(), iv, closeOutputStream);
        }
        return out;
    }

    public static InputStream wrapIfNecessary(Configuration conf, InputStream in, long length) throws IOException {
        if (CryptoUtils.isEncryptedSpillEnabled(conf)) {
            int bufferSize = CryptoUtils.getBufferSize(conf);
            if (length > -1L) {
                in = new LimitInputStream(in, length);
            }
            byte[] offsetArray = new byte[8];
            IOUtils.readFully(in, offsetArray, 0, 8);
            long offset = ByteBuffer.wrap(offsetArray).getLong();
            CryptoCodec cryptoCodec = CryptoCodec.getInstance(conf);
            byte[] iv = new byte[cryptoCodec.getCipherSuite().getAlgorithmBlockSize()];
            IOUtils.readFully(in, iv, 0, cryptoCodec.getCipherSuite().getAlgorithmBlockSize());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("IV read from [" + Base64.encodeBase64URLSafeString((byte[])iv) + "]"));
            }
            return new CryptoInputStream(in, cryptoCodec, bufferSize, CryptoUtils.getEncryptionKey(), iv, offset + (long)CryptoUtils.cryptoPadding(conf));
        }
        return in;
    }

    public static FSDataInputStream wrapIfNecessary(Configuration conf, FSDataInputStream in) throws IOException {
        if (CryptoUtils.isEncryptedSpillEnabled(conf)) {
            CryptoCodec cryptoCodec = CryptoCodec.getInstance(conf);
            int bufferSize = CryptoUtils.getBufferSize(conf);
            IOUtils.readFully(in, new byte[8], 0, 8);
            byte[] iv = new byte[cryptoCodec.getCipherSuite().getAlgorithmBlockSize()];
            IOUtils.readFully(in, iv, 0, cryptoCodec.getCipherSuite().getAlgorithmBlockSize());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("IV read from Stream [" + Base64.encodeBase64URLSafeString((byte[])iv) + "]"));
            }
            return new CryptoFSDataInputStream(in, cryptoCodec, bufferSize, CryptoUtils.getEncryptionKey(), iv);
        }
        return in;
    }
}

