/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.jobhistory;

import java.util.Set;
import org.apache.avro.util.Utf8;
import shaded.org.apache.hadoop.mapreduce.JobID;
import shaded.org.apache.hadoop.mapreduce.jobhistory.EventType;
import shaded.org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import shaded.org.apache.hadoop.mapreduce.jobhistory.JobQueueChange;
import shaded.org.apache.hadoop.util.StringUtils;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

public class JobQueueChangeEvent
implements HistoryEvent {
    private JobQueueChange datum = new JobQueueChange();

    public JobQueueChangeEvent(JobID id, String queueName) {
        this.datum.jobid = new Utf8(id.toString());
        this.datum.jobQueueName = new Utf8(queueName);
    }

    JobQueueChangeEvent() {
    }

    @Override
    public EventType getEventType() {
        return EventType.JOB_QUEUE_CHANGED;
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (JobQueueChange)((Object)datum);
    }

    public JobID getJobId() {
        return JobID.forName(this.datum.jobid.toString());
    }

    public String getJobQueueName() {
        if (this.datum.jobQueueName != null) {
            return this.datum.jobQueueName.toString();
        }
        return null;
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase(this.getEventType().name()));
        tEvent.addInfo("QUEUE_NAMES", this.getJobQueueName());
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        return null;
    }
}

