/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.jobhistory;

import java.util.Set;
import org.apache.avro.util.Utf8;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.mapreduce.TaskID;
import shaded.org.apache.hadoop.mapreduce.TaskType;
import shaded.org.apache.hadoop.mapreduce.jobhistory.EventType;
import shaded.org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import shaded.org.apache.hadoop.mapreduce.jobhistory.TaskStarted;
import shaded.org.apache.hadoop.util.StringUtils;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskStartedEvent
implements HistoryEvent {
    private TaskStarted datum = new TaskStarted();

    public TaskStartedEvent(TaskID id, long startTime, TaskType taskType, String splitLocations) {
        this.datum.setTaskid((CharSequence)new Utf8(id.toString()));
        this.datum.setSplitLocations((CharSequence)new Utf8(splitLocations));
        this.datum.setStartTime(startTime);
        this.datum.setTaskType((CharSequence)new Utf8(taskType.name()));
    }

    TaskStartedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (TaskStarted)((Object)datum);
    }

    public TaskID getTaskId() {
        return TaskID.forName(this.datum.getTaskid().toString());
    }

    public String getSplitLocations() {
        return this.datum.getSplitLocations().toString();
    }

    public long getStartTime() {
        return this.datum.getStartTime();
    }

    public TaskType getTaskType() {
        return TaskType.valueOf(this.datum.getTaskType().toString());
    }

    @Override
    public EventType getEventType() {
        return EventType.TASK_STARTED;
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase(this.getEventType().name()));
        tEvent.addInfo("TASK_TYPE", this.getTaskType().toString());
        tEvent.addInfo("START_TIME", this.getStartTime());
        tEvent.addInfo("SPLIT_LOCATIONS", this.getSplitLocations());
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        return null;
    }
}

