/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.lib.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.mapreduce.lib.db.DBInputFormat;
import shaded.org.apache.hadoop.mapreduce.lib.db.DBWritable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class DBConfiguration {
    public static final String DRIVER_CLASS_PROPERTY = "mapreduce.jdbc.driver.class";
    public static final String URL_PROPERTY = "mapreduce.jdbc.url";
    public static final String USERNAME_PROPERTY = "mapreduce.jdbc.username";
    public static final String PASSWORD_PROPERTY = "mapreduce.jdbc.password";
    public static final String INPUT_TABLE_NAME_PROPERTY = "mapreduce.jdbc.input.table.name";
    public static final String INPUT_FIELD_NAMES_PROPERTY = "mapreduce.jdbc.input.field.names";
    public static final String INPUT_CONDITIONS_PROPERTY = "mapreduce.jdbc.input.conditions";
    public static final String INPUT_ORDER_BY_PROPERTY = "mapreduce.jdbc.input.orderby";
    public static final String INPUT_QUERY = "mapreduce.jdbc.input.query";
    public static final String INPUT_COUNT_QUERY = "mapreduce.jdbc.input.count.query";
    public static final String INPUT_BOUNDING_QUERY = "mapred.jdbc.input.bounding.query";
    public static final String INPUT_CLASS_PROPERTY = "mapreduce.jdbc.input.class";
    public static final String OUTPUT_TABLE_NAME_PROPERTY = "mapreduce.jdbc.output.table.name";
    public static final String OUTPUT_FIELD_NAMES_PROPERTY = "mapreduce.jdbc.output.field.names";
    public static final String OUTPUT_FIELD_COUNT_PROPERTY = "mapreduce.jdbc.output.field.count";
    private Configuration conf;

    public static void configureDB(Configuration conf, String driverClass, String dbUrl, String userName, String passwd) {
        conf.set(DRIVER_CLASS_PROPERTY, driverClass);
        conf.set(URL_PROPERTY, dbUrl);
        if (userName != null) {
            conf.set(USERNAME_PROPERTY, userName);
        }
        if (passwd != null) {
            conf.set(PASSWORD_PROPERTY, passwd);
        }
    }

    public static void configureDB(Configuration job, String driverClass, String dbUrl) {
        DBConfiguration.configureDB(job, driverClass, dbUrl, null, null);
    }

    public DBConfiguration(Configuration job) {
        this.conf = job;
    }

    public Connection getConnection() throws ClassNotFoundException, SQLException {
        Class.forName(this.conf.get(DRIVER_CLASS_PROPERTY));
        if (this.conf.get(USERNAME_PROPERTY) == null) {
            return DriverManager.getConnection(this.conf.get(URL_PROPERTY));
        }
        return DriverManager.getConnection(this.conf.get(URL_PROPERTY), this.conf.get(USERNAME_PROPERTY), this.conf.get(PASSWORD_PROPERTY));
    }

    public Configuration getConf() {
        return this.conf;
    }

    public String getInputTableName() {
        return this.conf.get(INPUT_TABLE_NAME_PROPERTY);
    }

    public void setInputTableName(String tableName) {
        this.conf.set(INPUT_TABLE_NAME_PROPERTY, tableName);
    }

    public String[] getInputFieldNames() {
        return this.conf.getStrings(INPUT_FIELD_NAMES_PROPERTY);
    }

    public void setInputFieldNames(String ... fieldNames) {
        this.conf.setStrings(INPUT_FIELD_NAMES_PROPERTY, fieldNames);
    }

    public String getInputConditions() {
        return this.conf.get(INPUT_CONDITIONS_PROPERTY);
    }

    public void setInputConditions(String conditions) {
        if (conditions != null && conditions.length() > 0) {
            this.conf.set(INPUT_CONDITIONS_PROPERTY, conditions);
        }
    }

    public String getInputOrderBy() {
        return this.conf.get(INPUT_ORDER_BY_PROPERTY);
    }

    public void setInputOrderBy(String orderby) {
        if (orderby != null && orderby.length() > 0) {
            this.conf.set(INPUT_ORDER_BY_PROPERTY, orderby);
        }
    }

    public String getInputQuery() {
        return this.conf.get(INPUT_QUERY);
    }

    public void setInputQuery(String query) {
        if (query != null && query.length() > 0) {
            this.conf.set(INPUT_QUERY, query);
        }
    }

    public String getInputCountQuery() {
        return this.conf.get(INPUT_COUNT_QUERY);
    }

    public void setInputCountQuery(String query) {
        if (query != null && query.length() > 0) {
            this.conf.set(INPUT_COUNT_QUERY, query);
        }
    }

    public void setInputBoundingQuery(String query) {
        if (query != null && query.length() > 0) {
            this.conf.set(INPUT_BOUNDING_QUERY, query);
        }
    }

    public String getInputBoundingQuery() {
        return this.conf.get(INPUT_BOUNDING_QUERY);
    }

    public Class<?> getInputClass() {
        return this.conf.getClass(INPUT_CLASS_PROPERTY, DBInputFormat.NullDBWritable.class);
    }

    public void setInputClass(Class<? extends DBWritable> inputClass) {
        this.conf.setClass(INPUT_CLASS_PROPERTY, inputClass, DBWritable.class);
    }

    public String getOutputTableName() {
        return this.conf.get(OUTPUT_TABLE_NAME_PROPERTY);
    }

    public void setOutputTableName(String tableName) {
        this.conf.set(OUTPUT_TABLE_NAME_PROPERTY, tableName);
    }

    public String[] getOutputFieldNames() {
        return this.conf.getStrings(OUTPUT_FIELD_NAMES_PROPERTY);
    }

    public void setOutputFieldNames(String ... fieldNames) {
        this.conf.setStrings(OUTPUT_FIELD_NAMES_PROPERTY, fieldNames);
    }

    public void setOutputFieldCount(int fieldCount) {
        this.conf.setInt(OUTPUT_FIELD_COUNT_PROPERTY, fieldCount);
    }

    public int getOutputFieldCount() {
        return this.conf.getInt(OUTPUT_FIELD_COUNT_PROPERTY, 0);
    }
}

