/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.lib.input;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import shaded.org.apache.hadoop.conf.Configurable;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.io.Text;
import shaded.org.apache.hadoop.io.Writable;
import shaded.org.apache.hadoop.io.serializer.Deserializer;
import shaded.org.apache.hadoop.io.serializer.SerializationFactory;
import shaded.org.apache.hadoop.io.serializer.Serializer;
import shaded.org.apache.hadoop.mapreduce.InputFormat;
import shaded.org.apache.hadoop.mapreduce.InputSplit;
import shaded.org.apache.hadoop.mapreduce.Mapper;
import shaded.org.apache.hadoop.util.ReflectionUtils;
import shaded.org.apache.hadoop.util.StringInterner;

class TaggedInputSplit
extends InputSplit
implements Configurable,
Writable {
    private Class<? extends InputSplit> inputSplitClass;
    private InputSplit inputSplit;
    private Class<? extends InputFormat> inputFormatClass;
    private Class<? extends Mapper> mapperClass;
    private Configuration conf;

    public TaggedInputSplit() {
    }

    public TaggedInputSplit(InputSplit inputSplit, Configuration conf, Class<? extends InputFormat> inputFormatClass, Class<? extends Mapper> mapperClass) {
        this.inputSplitClass = inputSplit.getClass();
        this.inputSplit = inputSplit;
        this.conf = conf;
        this.inputFormatClass = inputFormatClass;
        this.mapperClass = mapperClass;
    }

    public InputSplit getInputSplit() {
        return this.inputSplit;
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return this.inputFormatClass;
    }

    public Class<? extends Mapper> getMapperClass() {
        return this.mapperClass;
    }

    @Override
    public long getLength() throws IOException, InterruptedException {
        return this.inputSplit.getLength();
    }

    @Override
    public String[] getLocations() throws IOException, InterruptedException {
        return this.inputSplit.getLocations();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.inputSplitClass = this.readClass(in);
        this.inputFormatClass = this.readClass(in);
        this.mapperClass = this.readClass(in);
        this.inputSplit = ReflectionUtils.newInstance(this.inputSplitClass, this.conf);
        SerializationFactory factory = new SerializationFactory(this.conf);
        Deserializer<? extends InputSplit> deserializer = factory.getDeserializer(this.inputSplitClass);
        deserializer.open((DataInputStream)in);
        this.inputSplit = deserializer.deserialize(this.inputSplit);
    }

    private Class<?> readClass(DataInput in) throws IOException {
        String className = StringInterner.weakIntern(Text.readString(in));
        try {
            return this.conf.getClassByName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("readObject can't find class", e);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.inputSplitClass.getName());
        Text.writeString(out, this.inputFormatClass.getName());
        Text.writeString(out, this.mapperClass.getName());
        SerializationFactory factory = new SerializationFactory(this.conf);
        Serializer<? extends InputSplit> serializer = factory.getSerializer(this.inputSplitClass);
        serializer.open((DataOutputStream)out);
        serializer.serialize(this.inputSplit);
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public String toString() {
        return this.inputSplit.toString();
    }
}

