/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.io.InputStream;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.FSDataInputStream;
import shaded.org.apache.hadoop.io.Text;
import shaded.org.apache.hadoop.mapreduce.lib.input.SplitLineReader;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class UncompressedSplitLineReader
extends SplitLineReader {
    private boolean needAdditionalRecord = false;
    private long splitLength;
    private long totalBytesRead = 0L;
    private boolean finished = false;
    private boolean usingCRLF;

    public UncompressedSplitLineReader(FSDataInputStream in, Configuration conf, byte[] recordDelimiterBytes, long splitLength) throws IOException {
        super((InputStream)in, conf, recordDelimiterBytes);
        this.splitLength = splitLength;
        this.usingCRLF = recordDelimiterBytes == null;
    }

    @Override
    protected int fillBuffer(InputStream in, byte[] buffer, boolean inDelimiter) throws IOException {
        long bytesLeftInSplit;
        int maxBytesToRead = buffer.length;
        if (this.totalBytesRead < this.splitLength && (bytesLeftInSplit = this.splitLength - this.totalBytesRead) < (long)maxBytesToRead) {
            maxBytesToRead = (int)bytesLeftInSplit;
        }
        int bytesRead = in.read(buffer, 0, maxBytesToRead);
        if (this.totalBytesRead == this.splitLength && inDelimiter && bytesRead > 0) {
            this.needAdditionalRecord = this.usingCRLF ? buffer[0] != 10 : true;
        }
        if (bytesRead > 0) {
            this.totalBytesRead += (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public int readLine(Text str, int maxLineLength, int maxBytesToConsume) throws IOException {
        int bytesRead = 0;
        if (!this.finished) {
            if (this.totalBytesRead > this.splitLength) {
                this.finished = true;
            }
            bytesRead = super.readLine(str, maxLineLength, maxBytesToConsume);
        }
        return bytesRead;
    }

    @Override
    public boolean needAdditionalRecordAfterSplit() {
        return !this.finished && this.needAdditionalRecord;
    }

    @Override
    protected void unsetNeedAdditionalRecordAfterSplit() {
        this.needAdditionalRecord = false;
    }
}

