/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.split;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.FSDataOutputStream;
import shaded.org.apache.hadoop.fs.FileSystem;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.fs.permission.FsPermission;
import shaded.org.apache.hadoop.io.Text;
import shaded.org.apache.hadoop.io.WritableUtils;
import shaded.org.apache.hadoop.io.serializer.SerializationFactory;
import shaded.org.apache.hadoop.io.serializer.Serializer;
import shaded.org.apache.hadoop.mapred.InputSplit;
import shaded.org.apache.hadoop.mapreduce.JobSubmissionFiles;
import shaded.org.apache.hadoop.mapreduce.split.JobSplit;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobSplitWriter {
    private static final Log LOG = LogFactory.getLog(JobSplitWriter.class);
    private static final int splitVersion = 1;
    private static final byte[] SPLIT_FILE_HEADER;

    public static <T extends shaded.org.apache.hadoop.mapreduce.InputSplit> void createSplitFiles(Path jobSubmitDir, Configuration conf, FileSystem fs, List<shaded.org.apache.hadoop.mapreduce.InputSplit> splits) throws IOException, InterruptedException {
        shaded.org.apache.hadoop.mapreduce.InputSplit[] array = splits.toArray(new shaded.org.apache.hadoop.mapreduce.InputSplit[splits.size()]);
        JobSplitWriter.createSplitFiles((Path)jobSubmitDir, (Configuration)conf, (FileSystem)fs, (shaded.org.apache.hadoop.mapreduce.InputSplit[])array);
    }

    public static <T extends shaded.org.apache.hadoop.mapreduce.InputSplit> void createSplitFiles(Path jobSubmitDir, Configuration conf, FileSystem fs, T[] splits) throws IOException, InterruptedException {
        FSDataOutputStream out = JobSplitWriter.createFile(fs, JobSubmissionFiles.getJobSplitFile(jobSubmitDir), conf);
        JobSplit.SplitMetaInfo[] info = JobSplitWriter.writeNewSplits((Configuration)conf, splits, (FSDataOutputStream)out);
        out.close();
        JobSplitWriter.writeJobSplitMetaInfo(fs, JobSubmissionFiles.getJobSplitMetaFile(jobSubmitDir), new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION), 1, info);
    }

    public static void createSplitFiles(Path jobSubmitDir, Configuration conf, FileSystem fs, InputSplit[] splits) throws IOException {
        FSDataOutputStream out = JobSplitWriter.createFile(fs, JobSubmissionFiles.getJobSplitFile(jobSubmitDir), conf);
        JobSplit.SplitMetaInfo[] info = JobSplitWriter.writeOldSplits(splits, out, conf);
        out.close();
        JobSplitWriter.writeJobSplitMetaInfo(fs, JobSubmissionFiles.getJobSplitMetaFile(jobSubmitDir), new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION), 1, info);
    }

    private static FSDataOutputStream createFile(FileSystem fs, Path splitFile, Configuration job) throws IOException {
        FSDataOutputStream out = FileSystem.create(fs, splitFile, new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION));
        int replication = job.getInt("mapreduce.client.submit.file.replication", 10);
        fs.setReplication(splitFile, (short)replication);
        JobSplitWriter.writeSplitHeader(out);
        return out;
    }

    private static void writeSplitHeader(FSDataOutputStream out) throws IOException {
        out.write(SPLIT_FILE_HEADER);
        out.writeInt(1);
    }

    private static <T extends shaded.org.apache.hadoop.mapreduce.InputSplit> JobSplit.SplitMetaInfo[] writeNewSplits(Configuration conf, T[] array, FSDataOutputStream out) throws IOException, InterruptedException {
        JobSplit.SplitMetaInfo[] info = new JobSplit.SplitMetaInfo[array.length];
        if (array.length != 0) {
            SerializationFactory factory = new SerializationFactory(conf);
            int i = 0;
            int maxBlockLocations = conf.getInt("mapreduce.job.max.split.locations", 10);
            long offset = out.getPos();
            for (T split : array) {
                long prevCount = out.getPos();
                Text.writeString(out, split.getClass().getName());
                Serializer<?> serializer = factory.getSerializer(split.getClass());
                serializer.open(out);
                serializer.serialize(split);
                long currCount = out.getPos();
                String[] locations = ((shaded.org.apache.hadoop.mapreduce.InputSplit)split).getLocations();
                if (locations.length > maxBlockLocations) {
                    LOG.warn((Object)("Max block location exceeded for split: " + split + " splitsize: " + locations.length + " maxsize: " + maxBlockLocations));
                    locations = Arrays.copyOf(locations, maxBlockLocations);
                }
                info[i++] = new JobSplit.SplitMetaInfo(locations, offset, ((shaded.org.apache.hadoop.mapreduce.InputSplit)split).getLength());
                offset += currCount - prevCount;
            }
        }
        return info;
    }

    private static JobSplit.SplitMetaInfo[] writeOldSplits(InputSplit[] splits, FSDataOutputStream out, Configuration conf) throws IOException {
        JobSplit.SplitMetaInfo[] info = new JobSplit.SplitMetaInfo[splits.length];
        if (splits.length != 0) {
            int i = 0;
            long offset = out.getPos();
            int maxBlockLocations = conf.getInt("mapreduce.job.max.split.locations", 10);
            for (InputSplit split : splits) {
                long prevLen = out.getPos();
                Text.writeString(out, split.getClass().getName());
                split.write(out);
                long currLen = out.getPos();
                String[] locations = split.getLocations();
                if (locations.length > maxBlockLocations) {
                    LOG.warn((Object)("Max block location exceeded for split: " + split + " splitsize: " + locations.length + " maxsize: " + maxBlockLocations));
                    locations = Arrays.copyOf(locations, maxBlockLocations);
                }
                info[i++] = new JobSplit.SplitMetaInfo(locations, offset, split.getLength());
                offset += currLen - prevLen;
            }
        }
        return info;
    }

    private static void writeJobSplitMetaInfo(FileSystem fs, Path filename, FsPermission p, int splitMetaInfoVersion, JobSplit.SplitMetaInfo[] allSplitMetaInfo) throws IOException {
        FSDataOutputStream out = FileSystem.create(fs, filename, p);
        out.write(JobSplit.META_SPLIT_FILE_HEADER);
        WritableUtils.writeVInt(out, splitMetaInfoVersion);
        WritableUtils.writeVInt(out, allSplitMetaInfo.length);
        for (JobSplit.SplitMetaInfo splitMetaInfo : allSplitMetaInfo) {
            splitMetaInfo.write(out);
        }
        out.close();
    }

    static {
        try {
            SPLIT_FILE_HEADER = "SPL".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException u) {
            throw new RuntimeException(u);
        }
    }
}

