/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.task;

import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.mapreduce.OutputCommitter;
import shaded.org.apache.hadoop.mapreduce.RecordWriter;
import shaded.org.apache.hadoop.mapreduce.StatusReporter;
import shaded.org.apache.hadoop.mapreduce.TaskAttemptID;
import shaded.org.apache.hadoop.mapreduce.TaskInputOutputContext;
import shaded.org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class TaskInputOutputContextImpl<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends TaskAttemptContextImpl
implements TaskInputOutputContext<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    private RecordWriter<KEYOUT, VALUEOUT> output;
    private OutputCommitter committer;

    public TaskInputOutputContextImpl(Configuration conf, TaskAttemptID taskid, RecordWriter<KEYOUT, VALUEOUT> output, OutputCommitter committer, StatusReporter reporter) {
        super(conf, taskid, reporter);
        this.output = output;
        this.committer = committer;
    }

    @Override
    public abstract boolean nextKeyValue() throws IOException, InterruptedException;

    @Override
    public abstract KEYIN getCurrentKey() throws IOException, InterruptedException;

    @Override
    public abstract VALUEIN getCurrentValue() throws IOException, InterruptedException;

    @Override
    public void write(KEYOUT key, VALUEOUT value) throws IOException, InterruptedException {
        this.output.write(key, value);
    }

    @Override
    public OutputCommitter getOutputCommitter() {
        return this.committer;
    }
}

