/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import java.io.InputStream;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.mapred.IFileInputStream;
import shaded.org.apache.hadoop.mapred.Reporter;
import shaded.org.apache.hadoop.mapreduce.TaskAttemptID;
import shaded.org.apache.hadoop.mapreduce.task.reduce.MapHost;
import shaded.org.apache.hadoop.mapreduce.task.reduce.MapOutput;
import shaded.org.apache.hadoop.mapreduce.task.reduce.MergeManagerImpl;
import shaded.org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;

public abstract class IFileWrappedMapOutput<K, V>
extends MapOutput<K, V> {
    private final Configuration conf;
    private final MergeManagerImpl<K, V> merger;

    public IFileWrappedMapOutput(Configuration c, MergeManagerImpl<K, V> m, TaskAttemptID mapId, long size, boolean primaryMapOutput) {
        super(mapId, size, primaryMapOutput);
        this.conf = c;
        this.merger = m;
    }

    protected MergeManagerImpl<K, V> getMerger() {
        return this.merger;
    }

    protected abstract void doShuffle(MapHost var1, IFileInputStream var2, long var3, long var5, ShuffleClientMetrics var7, Reporter var8) throws IOException;

    @Override
    public void shuffle(MapHost host, InputStream input, long compressedLength, long decompressedLength, ShuffleClientMetrics metrics, Reporter reporter) throws IOException {
        this.doShuffle(host, new IFileInputStream(input, compressedLength, this.conf), compressedLength, decompressedLength, metrics, reporter);
    }
}

