/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.v2.app.speculate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.JobId;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import shaded.org.apache.hadoop.mapreduce.v2.app.AppContext;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.Job;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.Task;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptStatusUpdateEvent;
import shaded.org.apache.hadoop.mapreduce.v2.app.speculate.DataStatistics;
import shaded.org.apache.hadoop.mapreduce.v2.app.speculate.TaskRuntimeEstimator;

abstract class StartEndTimesBase
implements TaskRuntimeEstimator {
    static final float MINIMUM_COMPLETE_PROPORTION_TO_SPECULATE = 0.05f;
    static final int MINIMUM_COMPLETE_NUMBER_TO_SPECULATE = 1;
    protected AppContext context = null;
    protected final Map<TaskAttemptId, Long> startTimes = new ConcurrentHashMap<TaskAttemptId, Long>();
    protected final Map<Job, DataStatistics> mapperStatistics = new HashMap<Job, DataStatistics>();
    protected final Map<Job, DataStatistics> reducerStatistics = new HashMap<Job, DataStatistics>();
    private final Map<Job, Float> slowTaskRelativeTresholds = new HashMap<Job, Float>();
    protected final Set<Task> doneTasks = new HashSet<Task>();

    StartEndTimesBase() {
    }

    @Override
    public void enrollAttempt(TaskAttemptStatusUpdateEvent.TaskAttemptStatus status, long timestamp) {
        this.startTimes.put(status.id, timestamp);
    }

    @Override
    public long attemptEnrolledTime(TaskAttemptId attemptID) {
        Long result = this.startTimes.get(attemptID);
        return result == null ? Long.MAX_VALUE : result;
    }

    @Override
    public void contextualize(Configuration conf, AppContext context) {
        this.context = context;
        Map<JobId, Job> allJobs = context.getAllJobs();
        for (Map.Entry<JobId, Job> entry : allJobs.entrySet()) {
            Job job = entry.getValue();
            this.mapperStatistics.put(job, new DataStatistics());
            this.reducerStatistics.put(job, new DataStatistics());
            this.slowTaskRelativeTresholds.put(job, Float.valueOf(conf.getFloat("mapreduce.job.speculative.slowtaskthreshold", 1.0f)));
        }
    }

    protected DataStatistics dataStatisticsForTask(TaskId taskID) {
        JobId jobID = taskID.getJobId();
        Job job = this.context.getJob(jobID);
        if (job == null) {
            return null;
        }
        Task task = job.getTask(taskID);
        if (task == null) {
            return null;
        }
        return task.getType() == TaskType.MAP ? this.mapperStatistics.get(job) : (task.getType() == TaskType.REDUCE ? this.reducerStatistics.get(job) : null);
    }

    @Override
    public long thresholdRuntime(TaskId taskID) {
        int totalTasksOfType;
        JobId jobID = taskID.getJobId();
        Job job = this.context.getJob(jobID);
        TaskType type = taskID.getTaskType();
        DataStatistics statistics = this.dataStatisticsForTask(taskID);
        int completedTasksOfType = type == TaskType.MAP ? job.getCompletedMaps() : job.getCompletedReduces();
        int n = totalTasksOfType = type == TaskType.MAP ? job.getTotalMaps() : job.getTotalReduces();
        if (completedTasksOfType < 1 || (float)completedTasksOfType / (float)totalTasksOfType < 0.05f) {
            return Long.MAX_VALUE;
        }
        long result = statistics == null ? Long.MAX_VALUE : (long)statistics.outlier(this.slowTaskRelativeTresholds.get(job).floatValue());
        return result;
    }

    @Override
    public long estimatedNewAttemptRuntime(TaskId id) {
        DataStatistics statistics = this.dataStatisticsForTask(id);
        if (statistics == null) {
            return -1L;
        }
        return (long)statistics.mean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAttempt(TaskAttemptStatusUpdateEvent.TaskAttemptStatus status, long timestamp) {
        TaskAttemptId attemptID = status.id;
        TaskId taskID = attemptID.getTaskId();
        JobId jobID = taskID.getJobId();
        Job job = this.context.getJob(jobID);
        if (job == null) {
            return;
        }
        Task task = job.getTask(taskID);
        if (task == null) {
            return;
        }
        Long boxedStart = this.startTimes.get(attemptID);
        long start = boxedStart == null ? Long.MIN_VALUE : boxedStart;
        TaskAttempt taskAttempt = task.getAttempt(attemptID);
        if (taskAttempt.getState() == TaskAttemptState.SUCCEEDED) {
            boolean isNew = false;
            Set<Task> set = this.doneTasks;
            synchronized (set) {
                if (!this.doneTasks.contains(task)) {
                    this.doneTasks.add(task);
                    isNew = true;
                }
            }
            if (isNew) {
                long finish = timestamp;
                if (start > 1L && finish > 1L && start <= finish) {
                    long duration = finish - start;
                    DataStatistics statistics = this.dataStatisticsForTask(taskID);
                    if (statistics != null) {
                        statistics.add(duration);
                    }
                }
            }
        }
    }

    @Override
    public boolean hasStagnatedProgress(TaskAttemptId id, long timeStamp) {
        return false;
    }
}

