/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.security.authorize;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.security.UserGroupInformation;
import shaded.org.apache.hadoop.security.authorize.AuthorizationException;
import shaded.org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import shaded.org.apache.hadoop.security.authorize.ImpersonationProvider;
import shaded.org.apache.hadoop.security.authorize.ProxyServers;
import shaded.org.apache.hadoop.util.ReflectionUtils;

@InterfaceStability.Unstable
@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce", "HBase", "Hive"})
public class ProxyUsers {
    public static final String CONF_HADOOP_PROXYUSER = "hadoop.proxyuser";
    private static volatile ImpersonationProvider sip;

    private static ImpersonationProvider getInstance(Configuration conf) {
        Class<ImpersonationProvider> clazz = conf.getClass("hadoop.security.impersonation.provider.class", DefaultImpersonationProvider.class, ImpersonationProvider.class);
        return ReflectionUtils.newInstance(clazz, conf);
    }

    public static void refreshSuperUserGroupsConfiguration() {
        ProxyUsers.refreshSuperUserGroupsConfiguration(new Configuration());
    }

    public static void refreshSuperUserGroupsConfiguration(Configuration conf, String proxyUserPrefix) {
        Preconditions.checkArgument((proxyUserPrefix != null && !proxyUserPrefix.isEmpty() ? 1 : 0) != 0, (Object)"prefix cannot be NULL or empty");
        ImpersonationProvider ip = ProxyUsers.getInstance(conf);
        ip.init(proxyUserPrefix);
        sip = ip;
        ProxyServers.refresh(conf);
    }

    public static void refreshSuperUserGroupsConfiguration(Configuration conf) {
        ProxyUsers.refreshSuperUserGroupsConfiguration(conf, CONF_HADOOP_PROXYUSER);
    }

    public static void authorize(UserGroupInformation user, String remoteAddress) throws AuthorizationException {
        if (sip == null) {
            ProxyUsers.refreshSuperUserGroupsConfiguration();
        }
        sip.authorize(user, remoteAddress);
    }

    @Deprecated
    public static void authorize(UserGroupInformation user, String remoteAddress, Configuration conf) throws AuthorizationException {
        ProxyUsers.authorize(user, remoteAddress);
    }

    @VisibleForTesting
    public static DefaultImpersonationProvider getDefaultImpersonationProvider() {
        return (DefaultImpersonationProvider)sip;
    }
}

