/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.util;

import java.io.IOException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.crypto.key.KeyProvider;
import shaded.org.apache.hadoop.crypto.key.KeyProviderFactory;

@InterfaceAudience.Private
public final class KMSUtil {
    public static final Logger LOG = LoggerFactory.getLogger(KMSUtil.class);

    private KMSUtil() {
    }

    public static KeyProvider createKeyProvider(Configuration conf, String configKeyName) throws IOException {
        LOG.debug("Creating key provider with config key {}", (Object)configKeyName);
        String providerUriStr = conf.getTrimmed(configKeyName);
        if (providerUriStr == null || providerUriStr.isEmpty()) {
            return null;
        }
        return KMSUtil.createKeyProviderFromUri(conf, URI.create(providerUriStr));
    }

    public static KeyProvider createKeyProviderFromUri(Configuration conf, URI providerUri) throws IOException {
        KeyProvider keyProvider = KeyProviderFactory.get(providerUri, conf);
        if (keyProvider == null) {
            throw new IOException("Could not instantiate KeyProvider for uri: " + providerUri);
        }
        if (keyProvider.isTransient()) {
            throw new IOException("KeyProvider " + keyProvider.toString() + " was found but it is a transient provider.");
        }
        return keyProvider;
    }
}

