/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Calendar;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.utils.URIBuilder;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ServletUtil {
    public static final String HTML_TAIL = "<hr />\n<a href='http://hadoop.apache.org/core'>Hadoop</a>, " + Calendar.getInstance().get(1) + ".\n" + "</body></html>";

    public static PrintWriter initHTML(ServletResponse response, String title) throws IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>\n<link rel='stylesheet' type='text/css' href='/static/hadoop.css'>\n<title>" + title + "</title>\n" + "<body>\n" + "<h1>" + title + "</h1>\n");
        return out;
    }

    public static String getParameter(ServletRequest request, String name) {
        String s = request.getParameter(name);
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    public static long parseLongParam(ServletRequest request, String param) throws IOException {
        String paramStr = request.getParameter(param);
        if (paramStr == null) {
            throw new IOException("Invalid request has no " + param + " parameter");
        }
        return Long.parseLong(paramStr);
    }

    public static String htmlFooter() {
        return HTML_TAIL;
    }

    public static String encodeQueryValue(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)("Failed to encode query value in UTF-8: " + value));
        }
    }

    public static String encodePath(String path) {
        return new URIBuilder().setPath(path).toString();
    }

    public static String decodePath(String path) {
        try {
            return new URI(path).getPath();
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)("Failed to decode URI: " + path));
        }
    }

    public static String getDecodedPath(HttpServletRequest request, String servletName) {
        String requestURI = request.getRequestURI();
        String uriPath = ServletUtil.getRawPath(request, servletName);
        try {
            return new URI(uriPath).getPath();
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)("Failed to decode URI: " + requestURI));
        }
    }

    public static String getRawPath(HttpServletRequest request, String servletName) {
        Preconditions.checkArgument((boolean)request.getRequestURI().startsWith(servletName + "/"));
        return request.getRequestURI().substring(servletName.length());
    }
}

